/*
 * Decompiled with CFR 0.152.
 */
package com.jkvin114.displaydelight.events;

import com.jkvin114.displaydelight.block.AbstractStackablePlatedFoodBlock;
import com.jkvin114.displaydelight.block.SmallPlatedFoodBlock;
import com.jkvin114.displaydelight.init.BlockAssociations;
import com.jkvin114.displaydelight.init.DisplayBlocks;
import com.jkvin114.displaydelight.init.DisplayConfig;
import com.jkvin114.displaydelight.init.DisplayTags;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class InterationManager {
    public static boolean tryTakeItemWithBareHand(Player player, ServerLevel world, BlockHitResult rez) {
        Block plateItem;
        InteractionHand handy = InteractionHand.MAIN_HAND;
        BlockPos pos = rez.getBlockPos();
        BlockState state = world.getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof AbstractStackablePlatedFoodBlock) {
            AbstractStackablePlatedFoodBlock target = (AbstractStackablePlatedFoodBlock)block;
            plateItem = BlockAssociations.getPlatedItemFor((Block)target);
            if (plateItem == Items.AIR && !player.isCreative()) {
                return false;
            }
            int count = 1;
            if (player.isShiftKeyDown()) {
                count = target.getStacks(state);
                world.setBlock(pos, ((Block)DisplayBlocks.PLATE.get()).defaultBlockState(), 2);
            } else if (target.getStacks(state) > 1) {
                BlockState newState = target.getDecrementedState(state);
                world.setBlock(pos, newState, 2);
            } else {
                world.setBlock(pos, ((Block)DisplayBlocks.PLATE.get()).defaultBlockState(), 2);
            }
            world.playSound(null, pos, SoundEvents.CHICKEN_EGG, SoundSource.PLAYERS, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
            HashSet<Block> set = new HashSet<Block>();
            set.add(plateItem);
            if (player.getInventory().hasAnyOf(set)) {
                player.getInventory().add(new ItemStack((ItemLike)plateItem, count));
            } else {
                player.setItemInHand(handy, new ItemStack((ItemLike)plateItem, count));
            }
            player.swing(handy, true);
            return true;
        }
        plateItem = state.getBlock();
        if (plateItem instanceof SmallPlatedFoodBlock) {
            SmallPlatedFoodBlock target = (SmallPlatedFoodBlock)plateItem;
            if ((plateItem = BlockAssociations.getSmallPlatedItemFor((Block)target)) == Items.AIR && !player.isCreative()) {
                return false;
            }
            world.setBlock(pos, ((Block)DisplayBlocks.SMALL_PLATE.get()).defaultBlockState(), 2);
            world.playSound(null, pos, SoundEvents.CHICKEN_EGG, SoundSource.PLAYERS, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
            HashSet<Block> set = new HashSet<Block>();
            set.add(plateItem);
            if (player.getInventory().hasAnyOf(set)) {
                player.getInventory().add(new ItemStack((ItemLike)plateItem, 1));
            } else {
                player.setItemInHand(handy, new ItemStack((ItemLike)plateItem, 1));
            }
            player.swing(handy, true);
            return true;
        }
        return false;
    }

    public static boolean tryPlaceItemOnSmallPlate(Player player, ServerLevel world, BlockHitResult rez, boolean isMainHand) {
        InteractionHand handy = isMainHand ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        ItemStack stack = player.getItemInHand(handy);
        if (!stack.is(DisplayTags.SMALL_PLATE_DISPLAYABLE)) {
            return false;
        }
        BlockPos pos = rez.getBlockPos();
        BlockState state = world.getBlockState(pos);
        if (!state.is((Block)DisplayBlocks.SMALL_PLATE.get())) {
            return false;
        }
        Block plateBlock = BlockAssociations.getSmallPlateBlockFor(stack.getItem());
        if (!(plateBlock instanceof SmallPlatedFoodBlock)) {
            return false;
        }
        SmallPlatedFoodBlock food = (SmallPlatedFoodBlock)plateBlock;
        UseOnContext ctx = new UseOnContext(player, handy, rez);
        BlockState newstate = food.getStateFrom(state, ctx.getHorizontalDirection());
        world.setBlock(pos, newstate, 2);
        world.playSound(null, pos, state.getSoundType((LevelReader)world, pos, (Entity)player).getPlaceSound(), SoundSource.BLOCKS, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
        if (!player.isCreative()) {
            stack.shrink(1);
        }
        player.swing(handy, true);
        return true;
    }

    public static boolean tryPlaceItemOnPlate(Player player, ServerLevel world, BlockHitResult rez, boolean isMainHand) {
        InteractionHand handy = isMainHand ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        ItemStack handStack = player.getItemInHand(handy);
        if (!handStack.is(DisplayTags.PLATE_DISPLAYABLE)) {
            return false;
        }
        BlockPos pos = rez.getBlockPos();
        BlockState state = world.getBlockState(pos);
        Block block = state.getBlock();
        if (block instanceof AbstractStackablePlatedFoodBlock) {
            AbstractStackablePlatedFoodBlock target = (AbstractStackablePlatedFoodBlock)block;
            if (handStack.is(target.getStackFor().getItem()) && target.getStacks(state) < target.getMaxStackable()) {
                int count = 1;
                if (player.isShiftKeyDown()) {
                    int stacksLeft = target.getMaxStackable() - target.getStacks(state);
                    count = player.isCreative() ? stacksLeft : Math.min(stacksLeft, handStack.getCount());
                }
                world.setBlock(pos, target.getIncrementedState(state, count), 2);
                world.playSound(null, pos, state.getSoundType((LevelReader)world, pos, (Entity)player).getPlaceSound(), SoundSource.BLOCKS, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
                if (!player.isCreative()) {
                    handStack.shrink(count);
                }
                player.swing(handy, true);
                return true;
            }
        } else if (state.is((Block)DisplayBlocks.PLATE.get())) {
            Block plateBlock = BlockAssociations.getPlateBlockFor(handStack.getItem());
            if (!(plateBlock instanceof AbstractStackablePlatedFoodBlock)) {
                return false;
            }
            AbstractStackablePlatedFoodBlock target = (AbstractStackablePlatedFoodBlock)plateBlock;
            int count = 1;
            if (player.isShiftKeyDown()) {
                int stacksLeft = target.getMaxStackable();
                count = player.isCreative() ? stacksLeft : Math.min(stacksLeft, handStack.getCount());
            }
            UseOnContext ctx = new UseOnContext(player, handy, rez);
            BlockState newstate = target.getStateFrom(state, ctx.getHorizontalDirection(), count);
            world.setBlock(pos, newstate, 2);
            world.playSound(null, pos, state.getSoundType((LevelReader)world, pos, (Entity)player).getPlaceSound(), SoundSource.BLOCKS, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
            if (!player.isCreative()) {
                handStack.shrink(count);
            }
            player.swing(handy, true);
            return true;
        }
        return false;
    }

    public static boolean tryPlaceItem(Player player, ServerLevel world, BlockHitResult rez, boolean isMainHand) {
        InteractionHand handy = isMainHand ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        ItemStack stack = player.getItemInHand(handy);
        if (!stack.is(DisplayTags.DISPLAYABLE)) {
            return false;
        }
        BlockPos pos = rez.getBlockPos();
        if (player.isShiftKeyDown()) {
            Block target = BlockAssociations.getBlockFor(stack.getItem());
            if (target.asItem().useOn(new UseOnContext(player, handy, rez)) == InteractionResult.CONSUME) {
                world.playSound(null, pos.above(), target.defaultBlockState().getSoundType((LevelReader)world, pos.above(), (Entity)player).getPlaceSound(), SoundSource.BLOCKS, 1.0f, (float)((double)0.8f + Math.random() * 0.2));
                player.swing(handy, true);
                return true;
            }
        } else if (world.getBlockState(pos).isFaceSturdy((BlockGetter)world, pos, Direction.UP) && rez.getDirection() == Direction.UP && ((Boolean)DisplayConfig.MESSAGE.get()).booleanValue()) {
            player.displayClientMessage((Component)Component.translatable((String)"item.displaydelight.tooltip.displayable"), true);
        }
        return false;
    }
}

