/*
 * Decompiled with CFR 0.152.
 */
package com.jkvin114.displaydelight.init;

import com.jkvin114.displaydelight.DisplayDelight;
import com.jkvin114.displaydelight.init.DisplayConfig;
import com.jkvin114.displaydelight.init.DisplayItems;
import com.jkvin114.displaydelight.init.DisplayTags;
import com.jkvin114.displaydelight.item.FoodBlockItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.neoforged.fml.ModList;

public class BlockAssociations {
    public static Map<Item, Block> blockMap = new HashMap<Item, Block>();
    public static Map<Block, Item> itemMap = new HashMap<Block, Item>();
    public static Map<Item, Block> plateBlockMap = new HashMap<Item, Block>();
    public static Map<Block, Item> plateItemMap = new HashMap<Block, Item>();
    public static Map<Item, Block> smallplateBlockMap = new HashMap<Item, Block>();
    public static Map<Block, Item> smallplateItemMap = new HashMap<Block, Item>();
    private static final String FARMERSDELIGHT = "farmersdelight";
    private static final String MINECRAFT = "minecraft";
    private static final String[] TypePrefixes = new String[]{"plated_", "small_plated_", ""};
    private static final Set<String> VanilaFoods = Set.of("mushroom_stew", "rabbit_stew", "beetroot_soup", "pumpkin_pie", "cookie");
    private static final Set<String> NO_WANDERING_TRADER = Set.of("nethersdelight");
    private static final Map<String, String> COMPAT_NAMESPACES = new HashMap<String, String>(){
        {
            this.put("", "");
            this.put("cd_", "corn_delight");
            this.put("ed_", "expandeddelight");
            this.put("df_", "delightful");
            this.put("pd_", "pineapple_delight");
            this.put("od_", "oceansdelight");
            this.put("ad_", "alexsdelight");
            this.put("ctd_", "culturaldelights");
            this.put("lm_", "largemeals");
            this.put("fd_", "festive_delight");
            this.put("bnc_", "brewinandchewin");
            this.put("acd_", "aquaculturedelight");
            this.put("erd_", "endersdelight");
            this.put("edd_", "ends_delight");
            this.put("mnd_", "mynethersdelight");
            this.put("nd_", "nethersdelight");
            this.put("crd_", "crabbersdelight");
        }
    };
    private static final Map<String, String> FULL_MODNAMES = new HashMap<String, String>(){
        {
            this.put(BlockAssociations.FARMERSDELIGHT, "Farmer's Delight");
            this.put("corn_delight", "Corn Delight");
            this.put("expandeddelight", "Expanded Delight");
            this.put("delightful", "Delightful");
            this.put("pineapple_delight", "Pineapple Delight");
            this.put("oceansdelight", "Ocean's Delight");
            this.put("alexsdelight", "Alex's Delight");
            this.put("culturaldelights", "Cultural Delights");
            this.put("largemeals", "Large Meals");
            this.put("festive_delight", "Festive Delight");
            this.put("brewinandchewin", "Brewin' and Chewin'");
            this.put("aquaculturedelight", "Aquaculture Delight");
            this.put("endersdelight", "Ender's Delight");
            this.put("ends_delight", "End's Delight");
            this.put("mynethersdelight", "My Nether's Delight");
            this.put("nethersdelight", "Nether's Delight");
            this.put("crabbersdelight", "Crabber's Delight");
        }
    };
    public static final List<Item> TRADEABLE_DRINKS = new ArrayList<Item>();
    public static final List<Item> TRADEABLE_FOODS = new ArrayList<Item>();
    public static final List<Item> TRADEABLE_PLATES = new ArrayList<Item>();
    public static final List<Item> TRADEABLE_SMALL_PLATES = new ArrayList<Item>();
    private static Item[] ALL_ITEMS = new Item[0];

    public static Item getRandomItem(RandomSource random) {
        return ALL_ITEMS[random.nextInt(ALL_ITEMS.length)];
    }

    public static Block getBlockFor(Item i) {
        return blockMap.getOrDefault(i, Blocks.AIR);
    }

    public static Item getItemFor(Block b) {
        return itemMap.getOrDefault(b, Items.AIR);
    }

    public static Block getPlateBlockFor(Item i) {
        return plateBlockMap.getOrDefault(i, Blocks.AIR);
    }

    public static Item getPlatedItemFor(Block b) {
        return plateItemMap.getOrDefault(b, Items.AIR);
    }

    public static Block getSmallPlateBlockFor(Item i) {
        return smallplateBlockMap.getOrDefault(i, Blocks.AIR);
    }

    public static Item getSmallPlatedItemFor(Block b) {
        return smallplateItemMap.getOrDefault(b, Items.AIR);
    }

    public static void addSmallPlateToMap(Item i, Block b) {
        smallplateBlockMap.putIfAbsent(i, b);
        smallplateItemMap.putIfAbsent(b, i);
    }

    public static void addToMap(Item i, Block b, boolean isPlated) {
        if (isPlated) {
            plateBlockMap.putIfAbsent(i, b);
            plateItemMap.putIfAbsent(b, i);
        } else {
            blockMap.putIfAbsent(i, b);
            itemMap.putIfAbsent(b, i);
        }
    }

    private static String getNamespace(String s) {
        for (String key : COMPAT_NAMESPACES.keySet()) {
            if (key.isEmpty() || !s.startsWith(key)) continue;
            return COMPAT_NAMESPACES.get(key);
        }
        return "";
    }

    private static String removeFirstPrefix(String s, Iterable<String> prefixes) {
        for (String prefix : prefixes) {
            if (prefix.isEmpty() || !s.startsWith(prefix)) continue;
            return s.substring(prefix.length());
        }
        return s;
    }

    private static String removePrefix(String s, String prefix) {
        if (s.startsWith(prefix)) {
            return s.substring(prefix.length());
        }
        return s;
    }

    public static boolean isItemInTag(Item item, TagKey<Item> tag) {
        ItemStack s = new ItemStack((ItemLike)item);
        return s.is(tag);
    }

    public static void initialize(Iterable<Item> allItems) {
        ArrayList<String> allPrefixes = new ArrayList<String>();
        for (String cp : COMPAT_NAMESPACES.keySet()) {
            for (String tp : TypePrefixes) {
                allPrefixes.add(cp + tp);
            }
        }
        for (Item item : allItems) {
            if (!(item instanceof FoodBlockItem) || item.equals(DisplayItems.PLATE.get()) || item.equals(DisplayItems.SMALL_PLATE.get())) continue;
            try {
                Item registeredFoodItem;
                String itemId = BuiltInRegistries.ITEM.getKey((Object)item).getPath();
                String foodName = BlockAssociations.removeFirstPrefix(itemId, allPrefixes);
                String foodNameWithPlate = BlockAssociations.removeFirstPrefix(itemId, COMPAT_NAMESPACES.keySet());
                String fullNamespace = BlockAssociations.getNamespace(itemId);
                boolean isVanila = false;
                if (fullNamespace.isEmpty()) {
                    if (VanilaFoods.contains(foodName)) {
                        fullNamespace = MINECRAFT;
                        isVanila = true;
                    } else {
                        fullNamespace = FARMERSDELIGHT;
                    }
                }
                if (!isVanila && !ModList.get().isLoaded(fullNamespace)) {
                    String name = FULL_MODNAMES.getOrDefault(fullNamespace, "");
                    ((FoodBlockItem)item).setRequiredModName(name);
                    boolean soldByTrader = true;
                    if (NO_WANDERING_TRADER.contains(fullNamespace)) {
                        soldByTrader = false;
                    }
                    if (soldByTrader) {
                        if (((FoodBlockItem)item).isDrink) {
                            TRADEABLE_DRINKS.add(item);
                        } else if (foodNameWithPlate.startsWith("plated_")) {
                            TRADEABLE_PLATES.add(item);
                        } else if (foodNameWithPlate.startsWith("small_plated_")) {
                            TRADEABLE_SMALL_PLATES.add(item);
                        } else {
                            TRADEABLE_FOODS.add(item);
                        }
                    }
                }
                if ((registeredFoodItem = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)fullNamespace, (String)foodName))) == Items.AIR) {
                    DisplayDelight.LOGGER.warn("{}:{} is not found from registry", (Object)fullNamespace, (Object)foodName);
                    continue;
                }
                if (foodNameWithPlate.startsWith("plated_")) {
                    if (!BlockAssociations.isItemInTag(registeredFoodItem, DisplayTags.PLATE_DISPLAYABLE)) continue;
                    BlockAssociations.addToMap(registeredFoodItem, ((BlockItem)item).getBlock(), true);
                    continue;
                }
                if (foodNameWithPlate.startsWith("small_plated_")) {
                    if (!BlockAssociations.isItemInTag(registeredFoodItem, DisplayTags.SMALL_PLATE_DISPLAYABLE)) continue;
                    BlockAssociations.addSmallPlateToMap(registeredFoodItem, ((BlockItem)item).getBlock());
                    continue;
                }
                if (!BlockAssociations.isItemInTag(registeredFoodItem, DisplayTags.DISPLAYABLE) || ((Boolean)DisplayConfig.DISABLE_VANILLA_FOODS.get()).booleanValue() && isVanila) continue;
                BlockAssociations.addToMap(registeredFoodItem, ((BlockItem)item).getBlock(), false);
            }
            catch (Exception e) {
                DisplayDelight.LOGGER.error("Failed to set block association for {}", (Object)BuiltInRegistries.ITEM.getKey((Object)item).getPath(), (Object)e);
            }
        }
        ArrayList<Item> combined = new ArrayList<Item>();
        combined.addAll(blockMap.keySet());
        combined.addAll(plateBlockMap.keySet());
        combined.addAll(smallplateBlockMap.keySet());
        ALL_ITEMS = (Item[])combined.toArray(Item[]::new);
    }
}

