/*
 * Decompiled with CFR 0.152.
 */
package com.jkvin114.displaydelight.trades;

import com.jkvin114.displaydelight.init.BlockAssociations;
import java.util.Optional;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class DisplayItemListing {

    public static class DrinkItemListing
    extends DisplayFoodItemListing {
        public DrinkItemListing(int price, int maxTrades, int xp, float priceMult) {
            super(price, maxTrades, xp, priceMult);
        }

        @Override
        public ItemStack ForSaleItem(Entity entity, RandomSource random) {
            Item randomItem = BlockAssociations.TRADEABLE_DRINKS.isEmpty() ? BlockAssociations.getRandomItem(random) : BlockAssociations.TRADEABLE_DRINKS.get(random.nextInt(BlockAssociations.TRADEABLE_DRINKS.size()));
            return new ItemStack((ItemLike)randomItem);
        }
    }

    public static class SmallPlatedItemListing
    extends DisplayFoodItemListing {
        public SmallPlatedItemListing(int price, int maxTrades, int xp, float priceMult) {
            super(price, maxTrades, xp, priceMult);
        }

        @Override
        public ItemStack ForSaleItem(Entity entity, RandomSource random) {
            Item randomItem = BlockAssociations.TRADEABLE_SMALL_PLATES.isEmpty() ? BlockAssociations.getRandomItem(random) : BlockAssociations.TRADEABLE_SMALL_PLATES.get(random.nextInt(BlockAssociations.TRADEABLE_SMALL_PLATES.size()));
            return new ItemStack((ItemLike)randomItem);
        }
    }

    public static class PlatedFoodItemListing
    extends DisplayFoodItemListing {
        public PlatedFoodItemListing(int price, int maxTrades, int xp, float priceMult) {
            super(price, maxTrades, xp, priceMult);
        }

        @Override
        public ItemStack ForSaleItem(Entity entity, RandomSource random) {
            Item randomItem = BlockAssociations.TRADEABLE_PLATES.isEmpty() ? BlockAssociations.getRandomItem(random) : BlockAssociations.TRADEABLE_PLATES.get(random.nextInt(BlockAssociations.TRADEABLE_PLATES.size()));
            return new ItemStack((ItemLike)randomItem);
        }
    }

    public static class FoodItemListing
    extends DisplayFoodItemListing {
        public FoodItemListing(int price, int maxTrades, int xp, float priceMult) {
            super(price, maxTrades, xp, priceMult);
        }

        @Override
        public ItemStack ForSaleItem(Entity entity, RandomSource random) {
            Item randomItem = BlockAssociations.TRADEABLE_FOODS.isEmpty() ? BlockAssociations.getRandomItem(random) : BlockAssociations.TRADEABLE_FOODS.get(random.nextInt(BlockAssociations.TRADEABLE_FOODS.size()));
            return new ItemStack((ItemLike)randomItem);
        }
    }

    public static abstract class DisplayFoodItemListing
    implements VillagerTrades.ItemListing {
        protected final int price;
        protected final int maxTrades;
        protected final int xp;
        protected final float priceMult;

        public DisplayFoodItemListing(int price, int maxTrades, int xp, float priceMult) {
            this.price = price;
            this.maxTrades = maxTrades;
            this.xp = xp;
            this.priceMult = priceMult;
        }

        public abstract ItemStack ForSaleItem(Entity var1, RandomSource var2);

        @Nullable
        public MerchantOffer getOffer(Entity entity, RandomSource randomSource) {
            ItemStack forsale = this.ForSaleItem(entity, randomSource);
            ItemStack tobuy = new ItemStack((ItemLike)Items.EMERALD, this.price);
            ItemCost cost = new ItemCost(tobuy.getItemHolder(), tobuy.getCount(), DataComponentPredicate.EMPTY, tobuy);
            return new MerchantOffer(cost, Optional.empty(), forsale, this.maxTrades, this.xp, this.priceMult);
        }
    }
}

