/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.random.economy;

import com.iafenvoy.random.economy.item.block.entity.TradeStationBlockEntity;
import com.iafenvoy.random.economy.registry.NeeBlockEntities;
import com.iafenvoy.random.economy.registry.NeeBlocks;
import com.iafenvoy.random.economy.registry.NeeCreativeTabs;
import com.iafenvoy.random.economy.registry.NeeDataComponents;
import com.iafenvoy.random.economy.registry.NeeItems;
import com.iafenvoy.random.economy.registry.NeeScreenHandlers;
import com.iafenvoy.random.economy.registry.NeeSounds;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.event.level.BlockEvent;

@Mod(value="random_economy")
@EventBusSubscriber
public final class RandomEconomy {
    public static final String MOD_ID = "random_economy";

    public RandomEconomy(ModContainer container, IEventBus bus) {
        NeeBlocks.REGISTRY.register(bus);
        NeeBlockEntities.REGISTRY.register(bus);
        NeeCreativeTabs.REGISTRY.register(bus);
        NeeDataComponents.REGISTRY.register(bus);
        NeeItems.REGISTRY.register(bus);
        NeeScreenHandlers.REGISTRY.register(bus);
        NeeSounds.REGISTRY.register(bus);
    }

    @SubscribeEvent
    public static void process(FMLCommonSetupEvent event) {
        event.enqueueWork(NeeItems::init);
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        BlockEntity blockEntity;
        LevelAccessor world = event.getLevel();
        BlockPos pos = event.getPos();
        Player player = event.getPlayer();
        if (world.getBlockState(pos).is((Block)NeeBlocks.TRADE_STATION.get()) && (blockEntity = world.getBlockEntity(pos)) instanceof TradeStationBlockEntity) {
            TradeStationBlockEntity be = (TradeStationBlockEntity)blockEntity;
            if (player.hasPermissions(2) && player.isCreative()) {
                return;
            }
            if (!Objects.equals(player.getUUID(), be.getOwner())) {
                event.setCanceled(true);
            }
        }
    }
}

