/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.random.economy;

import com.iafenvoy.random.economy.trade.PlayerExchangeHolder;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import it.unimi.dsi.fastutil.objects.Object2LongLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;

@EventBusSubscriber
public class TradeCommand {
    private static final Map<Player, Player> REQUESTS = new HashMap<Player, Player>();
    private static final Object2LongMap<Player> REQUEST_TIME = new Object2LongLinkedOpenHashMap();
    private static final long EXPIRE_TIME = 60000L;

    @SubscribeEvent
    public static void registerCommand(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"trade").requires(CommandSourceStack::isPlayer)).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).executes(ctx -> {
            ServerPlayer target;
            ServerPlayer self = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
            if (self.distanceToSqr((Entity)(target = EntityArgument.getPlayer((CommandContext)ctx, (String)"target"))) > 25.0) {
                self.sendSystemMessage((Component)Component.translatable((String)"command.random_economy.trade_too_far"));
                return 1;
            }
            if (REQUESTS.get(target) == self) {
                PlayerExchangeHolder.launchTrade(self, target);
                REQUESTS.remove(self);
                REQUESTS.remove(target);
                return 1;
            }
            REQUESTS.put((Player)self, (Player)target);
            REQUEST_TIME.put((Object)self, System.currentTimeMillis());
            self.sendSystemMessage((Component)Component.translatable((String)"command.random_economy.trade_request_sent"));
            target.sendSystemMessage((Component)Component.translatable((String)"command.random_economy.trade_request", (Object[])new Object[]{self.getDisplayName()}).withStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/trade " + self.getGameProfile().getName()))));
            return 1;
        })));
    }

    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Post event) {
        LinkedList<Player> forRemoval = new LinkedList<Player>();
        long cur = System.currentTimeMillis();
        for (Object2LongMap.Entry entry : REQUEST_TIME.object2LongEntrySet()) {
            if (entry.getLongValue() + 60000L >= cur) continue;
            forRemoval.add((Player)entry.getKey());
        }
        forRemoval.forEach(REQUESTS::remove);
        forRemoval.forEach(arg_0 -> REQUEST_TIME.removeLong(arg_0));
    }
}

