/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.random.economy.item;

import com.iafenvoy.random.economy.item.component.ChequeComponent;
import com.iafenvoy.random.economy.registry.NeeDataComponents;
import com.iafenvoy.random.economy.registry.NeeItems;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChequeItem
extends Item {
    private static final String VALUE_KEY = "cheque_value";
    private static final String OWNER_KEY = "cheque_owner";

    public ChequeItem() {
        super(new Item.Properties().rarity(Rarity.RARE).component(NeeDataComponents.CHEQUE, (Object)ChequeComponent.EMPTY));
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        int value = ChequeItem.getValue(stack);
        String owner = ChequeItem.getOwner(stack);
        if (value > 0) {
            tooltipComponents.add((Component)Component.translatable((String)"item.random_economy.value", (Object[])new Object[]{value}));
        }
        if (owner != null) {
            tooltipComponents.add((Component)Component.translatable((String)"item.random_economy.owner", (Object[])new Object[]{owner}));
        }
    }

    public static int getValue(ItemStack stack) {
        return ((ChequeComponent)stack.getOrDefault(NeeDataComponents.CHEQUE, (Object)ChequeComponent.EMPTY)).value();
    }

    @Nullable
    public static String getOwner(ItemStack stack) {
        return ((ChequeComponent)stack.getOrDefault(NeeDataComponents.CHEQUE, (Object)ChequeComponent.EMPTY)).owner();
    }

    public static ItemStack create(int value, String owner) {
        ItemStack stack = new ItemStack((ItemLike)NeeItems.CHEQUE.get());
        stack.set(NeeDataComponents.CHEQUE, (Object)new ChequeComponent(value, owner));
        return stack;
    }
}

