/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.random.economy.item;

import com.iafenvoy.random.economy.util.ThingWithPrice;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class CoinItem
extends Item
implements ThingWithPrice {
    private static final List<CoinItem> COINS = new LinkedList<CoinItem>();
    private final int value;

    public CoinItem(int value) {
        super(new Item.Properties().rarity(Rarity.UNCOMMON));
        this.value = value;
        COINS.add(this);
    }

    public int getValue() {
        return this.value;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.add((Component)Component.translatable((String)"item.random_economy.value", (Object[])new Object[]{this.value}));
    }

    public static int calculateValue(Container inv) {
        int value = 0;
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack stack = inv.getItem(i);
            Item item = stack.getItem();
            if (!(item instanceof CoinItem)) continue;
            CoinItem coinItem = (CoinItem)item;
            value += coinItem.getValue() * stack.getCount();
        }
        return value;
    }

    public static List<ItemStack> calculateCoins(int value) {
        LinkedList<ItemStack> list = new LinkedList<ItemStack>();
        for (CoinItem coinItem : COINS.stream().sorted(Comparator.comparingInt(CoinItem::getValue).reversed()).toList()) {
            int cnt = value / coinItem.getValue();
            value -= cnt * coinItem.getValue();
            while (cnt > 64) {
                list.add(new ItemStack((ItemLike)coinItem, 64));
                cnt -= 64;
            }
            if (cnt <= 0) continue;
            list.add(new ItemStack((ItemLike)coinItem, cnt));
        }
        return list;
    }
}

