/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.random.economy.item.block;

import com.iafenvoy.random.economy.item.block.WorkStationBlock;
import com.iafenvoy.random.economy.item.block.entity.TradeStationBlockEntity;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TradeStationBlock
extends WorkStationBlock
implements EntityBlock {
    public TradeStationBlock() {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CRAFTING_TABLE));
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new TradeStationBlockEntity(pos, state);
    }

    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TradeStationBlockEntity) {
            TradeStationBlockEntity blockEntity2 = (TradeStationBlockEntity)blockEntity;
            player.openMenu((MenuProvider)blockEntity2);
            return InteractionResult.SUCCESS;
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    public void setPlacedBy(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState state, @Nullable LivingEntity placer, @NotNull ItemStack itemStack) {
        super.setPlacedBy(world, pos, state, placer, itemStack);
        CompoundTag compound = ((CustomData)itemStack.getOrDefault(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.EMPTY)).copyTag();
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof TradeStationBlockEntity) {
            TradeStationBlockEntity blockEntity2 = (TradeStationBlockEntity)blockEntity;
            if (!compound.isEmpty()) {
                blockEntity2.loadAdditional(compound, (HolderLookup.Provider)world.registryAccess());
            } else if (placer instanceof Player) {
                Player player = (Player)placer;
                blockEntity2.setOwner(player.getUUID());
            }
        }
    }

    @NotNull
    public BlockState playerWillDestroy(Level world, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Player player) {
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof TradeStationBlockEntity) {
            TradeStationBlockEntity blockEntity2 = (TradeStationBlockEntity)blockEntity;
            if (Objects.equals(player.getUUID(), blockEntity2.getOwner())) {
                blockEntity2.dropInventory();
            } else if (player.hasPermissions(2) && player.isCreative()) {
                blockEntity2.dropFullBlock((HolderLookup.Provider)world.registryAccess());
            }
        }
        super.playerWillDestroy(world, pos, state, player);
        return state;
    }
}

