/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.random.economy.item.block.entity;

import com.iafenvoy.random.economy.registry.NeeBlockEntities;
import com.iafenvoy.random.economy.screen.handler.SystemStationCustomerScreenHandler;
import com.iafenvoy.random.economy.screen.handler.SystemStationOwnerScreenHandler;
import com.iafenvoy.random.economy.screen.inventory.ImplementedInventory;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SystemStationBlockEntity
extends BlockEntity
implements MenuProvider {
    private static final String OWNER_KEY = "owner";
    private static final String OWNER_NAME_KEY = "owner_name";
    @Nullable
    private UUID owner;
    @Nullable
    private String ownerNameCache;
    private final NonNullList<ItemStack> left = NonNullList.withSize((int)12, (Object)ItemStack.EMPTY);
    private final NonNullList<ItemStack> right = NonNullList.withSize((int)12, (Object)ItemStack.EMPTY);
    private final NonNullList<ItemStack> display = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);

    public SystemStationBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)NeeBlockEntities.SYSTEM_STATION.get(), pos, state);
    }

    public void loadAdditional(@NotNull CompoundTag nbt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        if (nbt.contains(OWNER_KEY, 11)) {
            this.owner = nbt.getUUID(OWNER_KEY);
        }
        if (nbt.contains(OWNER_NAME_KEY, 8)) {
            this.ownerNameCache = nbt.getString(OWNER_NAME_KEY);
        }
        this.display.clear();
        ContainerHelper.loadAllItems((CompoundTag)nbt.getCompound("display"), this.display, (HolderLookup.Provider)registries);
        ContainerHelper.loadAllItems((CompoundTag)nbt.getCompound("left"), this.left, (HolderLookup.Provider)registries);
        ContainerHelper.loadAllItems((CompoundTag)nbt.getCompound("right"), this.right, (HolderLookup.Provider)registries);
    }

    protected void saveAdditional(@NotNull CompoundTag nbt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        if (this.owner != null) {
            nbt.putUUID(OWNER_KEY, this.owner);
        }
        if (this.ownerNameCache != null) {
            nbt.putString(OWNER_NAME_KEY, this.ownerNameCache);
        }
        nbt.put("display", (Tag)ContainerHelper.saveAllItems((CompoundTag)new CompoundTag(), this.display, (HolderLookup.Provider)registries));
        nbt.put("left", (Tag)ContainerHelper.saveAllItems((CompoundTag)new CompoundTag(), this.left, (HolderLookup.Provider)registries));
        nbt.put("right", (Tag)ContainerHelper.saveAllItems((CompoundTag)new CompoundTag(), this.right, (HolderLookup.Provider)registries));
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"screen.random_economy.system_station");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, @NotNull Inventory playerInventory, Player player) {
        ContainerLevelAccess ctx = ContainerLevelAccess.create((Level)this.level, (BlockPos)this.worldPosition);
        if (player.hasPermissions(2) && player.isShiftKeyDown() && player.isCreative()) {
            return new SystemStationOwnerScreenHandler(syncId, playerInventory, ImplementedInventory.of(this.left, () -> ((SystemStationBlockEntity)this).setChanged()), ImplementedInventory.of(this.right, () -> {
                this.setChanged();
                if (this.level != null) {
                    this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 0);
                }
            }), ImplementedInventory.of(this.display, () -> {
                this.setChanged();
                if (this.level != null) {
                    this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 0);
                }
            }), ctx);
        }
        return new SystemStationCustomerScreenHandler(syncId, playerInventory, ImplementedInventory.of(this.left), ImplementedInventory.of(this.right), ctx);
    }

    public ItemStack getDisplayStack() {
        return (ItemStack)this.right.getFirst();
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }
}

