/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.random.economy.item.block.entity;

import com.iafenvoy.random.economy.registry.NeeBlockEntities;
import com.iafenvoy.random.economy.registry.NeeBlocks;
import com.iafenvoy.random.economy.screen.handler.TradeStationCustomerScreenHandler;
import com.iafenvoy.random.economy.screen.handler.TradeStationOwnerScreenHandler;
import com.iafenvoy.random.economy.screen.inventory.ImplementedInventory;
import com.mojang.authlib.GameProfile;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TradeStationBlockEntity
extends BlockEntity
implements MenuProvider {
    private static final String OWNER_KEY = "owner";
    private static final String OWNER_NAME_KEY = "owner_name";
    @Nullable
    private UUID owner;
    @Nullable
    private String ownerNameCache;
    private final NonNullList<ItemStack> left = NonNullList.withSize((int)12, (Object)ItemStack.EMPTY);
    private final NonNullList<ItemStack> right = NonNullList.withSize((int)12, (Object)ItemStack.EMPTY);
    private final NonNullList<ItemStack> inventory = NonNullList.withSize((int)21, (Object)ItemStack.EMPTY);
    private final NonNullList<ItemStack> display = NonNullList.withSize((int)1, (Object)ItemStack.EMPTY);

    public TradeStationBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)NeeBlockEntities.TRADE_STATION.get(), pos, state);
    }

    public void loadAdditional(@NotNull CompoundTag nbt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(nbt, registries);
        if (nbt.contains(OWNER_KEY, 11)) {
            this.owner = nbt.getUUID(OWNER_KEY);
        }
        if (nbt.contains(OWNER_NAME_KEY, 8)) {
            this.ownerNameCache = nbt.getString(OWNER_NAME_KEY);
        }
        this.display.clear();
        ContainerHelper.loadAllItems((CompoundTag)nbt.getCompound("display"), this.display, (HolderLookup.Provider)registries);
        ContainerHelper.loadAllItems((CompoundTag)nbt.getCompound("left"), this.left, (HolderLookup.Provider)registries);
        ContainerHelper.loadAllItems((CompoundTag)nbt.getCompound("right"), this.right, (HolderLookup.Provider)registries);
        ContainerHelper.loadAllItems((CompoundTag)nbt.getCompound("inventory"), this.inventory, (HolderLookup.Provider)registries);
    }

    protected void saveAdditional(@NotNull CompoundTag nbt, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(nbt, registries);
        if (this.owner != null) {
            nbt.putUUID(OWNER_KEY, this.owner);
        }
        if (this.ownerNameCache != null) {
            nbt.putString(OWNER_NAME_KEY, this.ownerNameCache);
        }
        nbt.put("display", (Tag)ContainerHelper.saveAllItems((CompoundTag)new CompoundTag(), this.display, (HolderLookup.Provider)registries));
        nbt.put("left", (Tag)ContainerHelper.saveAllItems((CompoundTag)new CompoundTag(), this.left, (HolderLookup.Provider)registries));
        nbt.put("right", (Tag)ContainerHelper.saveAllItems((CompoundTag)new CompoundTag(), this.right, (HolderLookup.Provider)registries));
        nbt.put("inventory", (Tag)ContainerHelper.saveAllItems((CompoundTag)new CompoundTag(), this.inventory, (HolderLookup.Provider)registries));
    }

    @Nullable
    public UUID getOwner() {
        return this.owner;
    }

    public void setOwner(@Nullable UUID owner) {
        this.owner = owner;
        this.ownerNameCache = Optional.ofNullable(this.getLevel()).map(x -> x.getPlayerByUUID(owner)).map(Player::getGameProfile).map(GameProfile::getName).orElse(null);
        this.setChanged();
        if (this.level != null) {
            this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 0);
        }
    }

    public Component getFloatingName() {
        String ownerName = this.getOwnerName();
        if (ownerName != null) {
            return Component.translatable((String)"screen.random_economy.trade_station_float", (Object[])new Object[]{ownerName});
        }
        return Component.translatable((String)"screen.random_economy.trade_station_empty");
    }

    @NotNull
    public Component getDisplayName() {
        String ownerName = this.getOwnerName();
        if (ownerName != null) {
            return Component.translatable((String)"screen.random_economy.trade_station", (Object[])new Object[]{ownerName});
        }
        return Component.translatable((String)"screen.random_economy.trade_station_empty");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int syncId, @NotNull Inventory playerInventory, Player player) {
        ContainerLevelAccess ctx = ContainerLevelAccess.create((Level)this.level, (BlockPos)this.worldPosition);
        if (Objects.equals(this.getOwner(), player.getUUID())) {
            return new TradeStationOwnerScreenHandler(syncId, playerInventory, ImplementedInventory.of(this.left, () -> ((TradeStationBlockEntity)this).setChanged()), ImplementedInventory.of(this.right, () -> ((TradeStationBlockEntity)this).setChanged()), ImplementedInventory.of(this.inventory, () -> ((TradeStationBlockEntity)this).setChanged()), ImplementedInventory.of(this.display, () -> {
                this.setChanged();
                if (this.level != null) {
                    this.level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 0);
                }
            }), ctx);
        }
        return new TradeStationCustomerScreenHandler(syncId, playerInventory, ImplementedInventory.of(this.left), ImplementedInventory.of(this.right), ImplementedInventory.of(this.inventory, () -> ((TradeStationBlockEntity)this).setChanged()), ctx);
    }

    public ItemStack getDisplayStack() {
        return (ItemStack)this.display.getFirst();
    }

    @Nullable
    public String getOwnerName() {
        if (this.getOwner() == null) {
            return this.ownerNameCache;
        }
        return Optional.ofNullable(this.getLevel()).map(x -> x.getPlayerByUUID(this.getOwner())).map(Player::getGameProfile).map(GameProfile::getName).orElse(this.ownerNameCache);
    }

    public void dropInventory() {
        assert (this.level != null);
        for (ItemStack stack : this.inventory) {
            ItemEntity itemEntity = new ItemEntity(this.level, (double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5, stack);
            itemEntity.setDefaultPickUpDelay();
            this.level.addFreshEntity((Entity)itemEntity);
        }
    }

    public void dropFullBlock(HolderLookup.Provider registries) {
        assert (this.level != null);
        ItemStack stack = new ItemStack((ItemLike)NeeBlocks.TRADE_STATION.get());
        CompoundTag compound = new CompoundTag();
        this.saveAdditional(compound, registries);
        BlockItem.setBlockEntityData((ItemStack)stack, (BlockEntityType)((BlockEntityType)NeeBlockEntities.TRADE_STATION.get()), (CompoundTag)compound);
        ItemEntity itemEntity = new ItemEntity(this.level, (double)this.worldPosition.getX() + 0.5, (double)this.worldPosition.getY() + 0.5, (double)this.worldPosition.getZ() + 0.5, stack);
        itemEntity.setDefaultPickUpDelay();
        this.level.addFreshEntity((Entity)itemEntity);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }
}

