/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.random.economy.registry;

import com.iafenvoy.random.economy.item.ChequeItem;
import com.iafenvoy.random.economy.item.CoinItem;
import com.iafenvoy.random.economy.registry.NeeCreativeTabs;
import com.iafenvoy.random.economy.trade.CoinExchangeHolder;
import java.util.function.Supplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;

public final class NeeItems {
    public static final DeferredRegister.Items REGISTRY = DeferredRegister.createItems((String)"random_economy");
    public static final DeferredItem<CoinItem> COPPER_COIN = NeeItems.register("copper_coin", () -> new CoinItem(1));
    public static final DeferredItem<CoinItem> IRON_COIN = NeeItems.register("iron_coin", () -> new CoinItem(10));
    public static final DeferredItem<CoinItem> GOLD_COIN = NeeItems.register("gold_coin", () -> new CoinItem(100));
    public static final DeferredItem<CoinItem> DIAMOND_COIN = NeeItems.register("diamond_coin", () -> new CoinItem(1000));
    public static final DeferredItem<CoinItem> EMERALD_COIN = NeeItems.register("emerald_coin", () -> new CoinItem(10000));
    public static final DeferredItem<CoinItem> NETHERITE_COIN = NeeItems.register("netherite_coin", () -> new CoinItem(100000));
    public static final DeferredItem<ChequeItem> CHEQUE = NeeItems.register("cheque", ChequeItem::new);

    public static <T extends Item> DeferredItem<T> register(String id, Supplier<T> item) {
        DeferredItem r = REGISTRY.register(id, item);
        NeeCreativeTabs.ITEMS.add(() -> ((DeferredItem)r).get());
        return r;
    }

    public static void init() {
        CoinExchangeHolder.register((Item)COPPER_COIN.get(), new CoinExchangeHolder(Items.AIR, 0, (Item)IRON_COIN.get(), 10));
        CoinExchangeHolder.register((Item)IRON_COIN.get(), new CoinExchangeHolder((Item)COPPER_COIN.get(), 10, (Item)GOLD_COIN.get(), 10));
        CoinExchangeHolder.register((Item)GOLD_COIN.get(), new CoinExchangeHolder((Item)IRON_COIN.get(), 10, (Item)DIAMOND_COIN.get(), 10));
        CoinExchangeHolder.register((Item)DIAMOND_COIN.get(), new CoinExchangeHolder((Item)GOLD_COIN.get(), 10, (Item)EMERALD_COIN.get(), 10));
        CoinExchangeHolder.register((Item)EMERALD_COIN.get(), new CoinExchangeHolder((Item)DIAMOND_COIN.get(), 10, (Item)NETHERITE_COIN.get(), 10));
        CoinExchangeHolder.register((Item)NETHERITE_COIN.get(), new CoinExchangeHolder((Item)EMERALD_COIN.get(), 10, Items.AIR, 0));
    }
}

