/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.random.economy.render;

import com.iafenvoy.random.economy.item.block.entity.SystemStationBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.world.item.ItemDisplayContext;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class SystemStationBlockEntityRenderer
implements BlockEntityRenderer<SystemStationBlockEntity> {
    private final ItemRenderer itemRenderer;

    public SystemStationBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        this.itemRenderer = ctx.getItemRenderer();
    }

    public void render(SystemStationBlockEntity entity, float tickDelta, @NotNull PoseStack matrices, @NotNull MultiBufferSource vertexConsumers, int light, int overlay) {
        if (entity.getDisplayStack().isEmpty()) {
            return;
        }
        matrices.pushPose();
        matrices.translate(0.5, 0.5, 0.5);
        this.renderItem(entity, tickDelta, matrices, vertexConsumers, overlay);
        matrices.popPose();
    }

    private void renderItem(SystemStationBlockEntity entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int overlay) {
        matrices.pushPose();
        assert (entity.getLevel() != null);
        matrices.translate(0.0, 0.75, 0.0);
        matrices.mulPose(Axis.YP.rotationDegrees(((float)entity.getLevel().getGameTime() + tickDelta) * 4.0f));
        matrices.scale(1.5f, 1.5f, 1.5f);
        this.itemRenderer.renderStatic(entity.getDisplayStack(), ItemDisplayContext.GROUND, 0xF000D0, overlay, matrices, vertexConsumers, entity.getLevel(), 0);
        matrices.popPose();
    }
}

