/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.random.economy.render;

import com.iafenvoy.random.economy.item.block.entity.TradeStationBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class TradeStationBlockEntityRenderer
implements BlockEntityRenderer<TradeStationBlockEntity> {
    private final ItemRenderer itemRenderer;
    private final BlockEntityRenderDispatcher dispatcher;
    private final Font textRenderer;

    public TradeStationBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
        this.itemRenderer = ctx.getItemRenderer();
        this.dispatcher = ctx.getBlockEntityRenderDispatcher();
        this.textRenderer = ctx.getFont();
    }

    public void render(TradeStationBlockEntity entity, float tickDelta, @NotNull PoseStack matrices, @NotNull MultiBufferSource vertexConsumers, int light, int overlay) {
        if (entity.getDisplayStack().isEmpty()) {
            return;
        }
        matrices.pushPose();
        matrices.translate(0.5, 0.5, 0.5);
        this.renderItem(entity, tickDelta, matrices, vertexConsumers, overlay);
        Minecraft client = Minecraft.getInstance();
        HitResult hitResult = client.hitResult;
        if (hitResult instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            if (client.level != null && client.level.getBlockEntity(blockHitResult.getBlockPos()) == entity) {
                this.renderLabelIfPresent(entity, entity.getFloatingName(), matrices, vertexConsumers);
            }
        }
        matrices.popPose();
    }

    private void renderItem(TradeStationBlockEntity entity, float tickDelta, PoseStack matrices, MultiBufferSource vertexConsumers, int overlay) {
        matrices.pushPose();
        assert (entity.getLevel() != null);
        matrices.translate(0.0, 0.75, 0.0);
        matrices.scale(1.5f, 1.5f, 1.5f);
        this.itemRenderer.renderStatic(entity.getDisplayStack(), ItemDisplayContext.GROUND, 0xF000D0, overlay, matrices, vertexConsumers, entity.getLevel(), 0);
        matrices.popPose();
    }

    private void renderLabelIfPresent(TradeStationBlockEntity entity, Component text, PoseStack matrices, MultiBufferSource vertexConsumers) {
        double yOffset = 1.5;
        double d = this.dispatcher.camera.getPosition().distanceToSqr(entity.getBlockPos().getCenter().add(0.0, yOffset, 0.0));
        if (d <= 4096.0) {
            matrices.pushPose();
            matrices.translate(0.0, yOffset, 0.0);
            matrices.mulPose(this.dispatcher.camera.rotation());
            matrices.scale(-0.025f, -0.025f, 0.025f);
            Matrix4f matrix4f = matrices.last().pose();
            float g = Minecraft.getInstance().options.getBackgroundOpacity(0.25f);
            int j = (int)(g * 255.0f) << 24;
            float h = -this.textRenderer.width((FormattedText)text) / 2;
            this.textRenderer.drawInBatch(text, h, 0.0f, 0x20FFFFFF, false, matrix4f, vertexConsumers, Font.DisplayMode.SEE_THROUGH, j, 0xF000D0);
            this.textRenderer.drawInBatch(text, h, 0.0f, -1, false, matrix4f, vertexConsumers, Font.DisplayMode.NORMAL, 0, 0xF000D0);
            matrices.popPose();
        }
    }
}

