/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.random.economy.screen;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class InventoryUtil {
    public static boolean hasAllItems(Container target, Container items) {
        int i;
        target = InventoryUtil.copy(target);
        HashMap<StackHolder, Integer> itemsMap = new HashMap<StackHolder, Integer>();
        for (i = 0; i < items.getContainerSize(); ++i) {
            ItemStack stack = items.getItem(i);
            if (stack.isEmpty()) continue;
            StackHolder holder = new StackHolder(stack);
            itemsMap.put(holder, itemsMap.getOrDefault(holder, 0) + stack.getCount());
        }
        block1: for (i = 0; i < target.getContainerSize(); ++i) {
            ItemStack targetStack = target.getItem(i);
            for (Map.Entry entry : itemsMap.entrySet()) {
                StackHolder stack = (StackHolder)entry.getKey();
                int neededCount = (Integer)entry.getValue();
                if (!stack.areEqual(targetStack)) continue;
                int count = targetStack.getCount();
                if (count >= neededCount) {
                    itemsMap.put(stack, 0);
                    continue block1;
                }
                itemsMap.put(stack, neededCount - count);
                continue block1;
            }
        }
        Iterator iterator = itemsMap.values().iterator();
        while (iterator.hasNext()) {
            int count = (Integer)iterator.next();
            if (count <= 0) continue;
            return false;
        }
        return true;
    }

    public static boolean removeItems(Container target, Container items) {
        int i;
        HashMap<StackHolder, Integer> itemsMap = new HashMap<StackHolder, Integer>();
        for (i = 0; i < items.getContainerSize(); ++i) {
            ItemStack stack = items.getItem(i);
            if (stack.isEmpty()) continue;
            StackHolder holder = new StackHolder(stack);
            itemsMap.put(holder, itemsMap.getOrDefault(holder, 0) + stack.getCount());
        }
        block1: for (i = 0; i < target.getContainerSize(); ++i) {
            ItemStack targetStack = target.getItem(i);
            for (Map.Entry entry : itemsMap.entrySet()) {
                StackHolder stack = (StackHolder)entry.getKey();
                int neededCount = (Integer)entry.getValue();
                if (!stack.areEqual(targetStack)) continue;
                int count = targetStack.getCount();
                if (count >= neededCount) {
                    targetStack.shrink(neededCount);
                    itemsMap.put(stack, 0);
                    continue block1;
                }
                itemsMap.put(stack, neededCount - count);
                targetStack.setCount(0);
            }
        }
        Iterator iterator = itemsMap.values().iterator();
        while (iterator.hasNext()) {
            int count = (Integer)iterator.next();
            if (count <= 0) continue;
            return false;
        }
        return true;
    }

    public static boolean canFitItems(Container inventory, Container in, Container out) {
        return InventoryUtil.removeItems(inventory = InventoryUtil.copy(inventory), out) && InventoryUtil.insertItems(inventory, in);
    }

    public static boolean insertItems(Container inventory, Container insert) {
        for (int i = 0; i < insert.getContainerSize(); ++i) {
            ItemStack insertStack = insert.getItem(i);
            if (InventoryUtil.tryAddItemToInventory(inventory, insertStack.copy())) continue;
            return false;
        }
        return true;
    }

    private static boolean tryAddItemToInventory(Container inventory, ItemStack stack) {
        if (stack.isEmpty()) {
            return true;
        }
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack inventoryStack = inventory.getItem(i);
            if (!ItemStack.isSameItemSameComponents((ItemStack)inventoryStack, (ItemStack)stack) || stack.getMaxStackSize() - inventoryStack.getCount() <= 0) continue;
            int countToAdd = Math.min(stack.getCount(), stack.getMaxStackSize() - inventoryStack.getCount());
            inventoryStack.grow(countToAdd);
            stack.shrink(countToAdd);
            if (stack.getCount() != 0) continue;
            return true;
        }
        if (inventory instanceof Inventory) {
            Inventory playerInventory = (Inventory)inventory;
            playerInventory.placeItemBackInInventory(stack);
            return true;
        }
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            if (!inventory.getItem(i).isEmpty()) continue;
            inventory.setItem(i, stack);
            return true;
        }
        return false;
    }

    public static Container copy(Container another) {
        SimpleContainer inventory = new SimpleContainer(another.getContainerSize());
        for (int i = 0; i < another.getContainerSize(); ++i) {
            inventory.setItem(i, another.getItem(i).copy());
        }
        return inventory;
    }

    public record StackHolder(Item item, @Nullable DataComponentMap components) {
        public StackHolder(ItemStack stack) {
            this(stack.getItem(), stack.getComponents());
        }

        public boolean areEqual(ItemStack stack) {
            return stack.is(this.item) && Objects.equals(stack.getComponents(), this.components);
        }
    }
}

