/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.random.economy.screen.gui;

import com.iafenvoy.random.economy.network.payload.TradeStateChangePayload;
import com.iafenvoy.random.economy.screen.handler.TradeCommandScreenHandler;
import com.iafenvoy.random.economy.trade.TradeMessageType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class TradeCommandScreen
extends AbstractContainerScreen<TradeCommandScreenHandler> {
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"random_economy", (String)"textures/gui/trade_command.png");
    private Button self;
    private Button another;
    private boolean accepted;

    public TradeCommandScreen(TradeCommandScreenHandler handler, Inventory inventory, Component title) {
        super((AbstractContainerMenu)handler, inventory, title);
        this.imageWidth = 175;
        this.imageHeight = 221;
        this.inventoryLabelY = 128;
    }

    protected void init() {
        super.init();
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        this.self = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"screen.random_economy.trade.button.accept"), button -> {
            this.accepted ^= true;
            PacketDistributor.sendToServer((CustomPacketPayload)new TradeStateChangePayload(this.accepted ? TradeMessageType.SELF_ACCEPT : TradeMessageType.SELF_CANCEL_ACCEPT), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.self.setMessage((Component)Component.translatable((String)("screen.random_economy.trade.button." + (this.accepted ? "accepted" : "accept"))));
        }).pos(i + 7, j + 110).size(72, 16).build());
        this.another = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"screen.random_economy.trade.button.waiting"), button -> {}).pos(i + 97, j + 110).size(72, 16).build());
        this.another.active = false;
    }

    public void render(@NotNull GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.render(context, mouseX, mouseY, delta);
        this.renderTooltip(context, mouseX, mouseY);
    }

    protected void renderLabels(@NotNull GuiGraphics context, int mouseX, int mouseY) {
        super.renderLabels(context, mouseX, mouseY);
        context.drawString(this.font, ((TradeCommandScreenHandler)this.menu).getAnotherPlayerName(), this.titleLabelX + 90, this.titleLabelY, 0x404040, false);
    }

    protected void renderBg(GuiGraphics context, float delta, int mouseX, int mouseY) {
        int i = (this.width - this.imageWidth) / 2;
        int j = (this.height - this.imageHeight) / 2;
        context.blit(TEXTURE, i, j, 0, 0, this.imageWidth, this.imageHeight);
    }

    public void onClose() {
        super.onClose();
        PacketDistributor.sendToServer((CustomPacketPayload)new TradeStateChangePayload(TradeMessageType.SELF_CLOSE_SCREEN), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void onTradeStateChange(TradeStateChangePayload payload, IPayloadContext context) {
        TradeMessageType type = payload.message();
        Minecraft client = Minecraft.getInstance();
        Screen screen = client.screen;
        if (!(screen instanceof TradeCommandScreen)) {
            return;
        }
        TradeCommandScreen trade = (TradeCommandScreen)screen;
        client.execute(switch (type) {
            case TradeMessageType.ANOTHER_ACCEPT -> () -> trade.another.setMessage((Component)Component.translatable((String)"screen.random_economy.trade.button.accepted"));
            case TradeMessageType.ANOTHER_CANCEL_ACCEPT -> () -> trade.another.setMessage((Component)Component.translatable((String)"screen.random_economy.trade.button.waiting"));
            case TradeMessageType.ANOTHER_CLOSE_SCREEN -> () -> client.setScreen(null);
            default -> TradeMessageType.EMPTY;
        });
    }
}

