/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.random.economy.screen.handler;

import com.iafenvoy.random.economy.item.ChequeItem;
import com.iafenvoy.random.economy.item.CoinItem;
import com.iafenvoy.random.economy.item.component.ChequeComponent;
import com.iafenvoy.random.economy.registry.NeeBlocks;
import com.iafenvoy.random.economy.registry.NeeDataComponents;
import com.iafenvoy.random.economy.registry.NeeItems;
import com.iafenvoy.random.economy.registry.NeeScreenHandlers;
import com.iafenvoy.random.economy.screen.ScreenHandlerUtils;
import com.iafenvoy.random.economy.screen.slot.InputPredicateSlot;
import com.iafenvoy.random.economy.screen.slot.TakeOnlySlotWithCallback;
import com.iafenvoy.random.economy.util.ThingWithPrice;
import java.util.List;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class ChequeTableScreenHandler
extends AbstractContainerMenu {
    private final Container coins = new SimpleContainer(15);
    private final Container chequesInput = new SimpleContainer(1);
    private final Container chequesOutput = new SimpleContainer(1);
    private final ContainerLevelAccess context;

    public ChequeTableScreenHandler(int syncId, Inventory playerInventory) {
        this(syncId, playerInventory, ContainerLevelAccess.NULL);
    }

    public ChequeTableScreenHandler(int syncId, Inventory playerInventory, ContainerLevelAccess context) {
        super((MenuType)NeeScreenHandlers.CHEQUE_TABLE.get(), syncId);
        int j;
        int i;
        this.context = context;
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 5; ++j) {
                this.addSlot(new InputPredicateSlot(this.coins, j + i * 5, 8 + j * 18, 18 + i * 18, stack -> stack.getItem() instanceof ThingWithPrice));
            }
        }
        this.addSlot(new InputPredicateSlot(this.chequesInput, 0, 134, 18, stack -> stack.is((Item)NeeItems.CHEQUE.get())));
        this.addSlot(new TakeOnlySlotWithCallback(this, this.chequesOutput, 0, 134, 54, amount -> {}));
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int slot) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot2 = (Slot)this.slots.get(slot);
        if (slot2.hasItem()) {
            ItemStack itemStack2 = slot2.getItem();
            itemStack = itemStack2.copy();
            if (slot < this.coins.getContainerSize() + 2) {
                if (!this.moveItemStackTo(itemStack2, this.coins.getContainerSize() + 2, this.slots.size(), true)) {
                    return ItemStack.EMPTY;
                }
                slot2.onTake(player, itemStack);
            } else if (!this.moveItemStackTo(itemStack2, 0, this.coins.getContainerSize() + 1, false)) {
                return ItemStack.EMPTY;
            }
            if (itemStack2.isEmpty()) {
                slot2.setByPlayer(ItemStack.EMPTY);
            } else {
                slot2.setChanged();
            }
        }
        return itemStack;
    }

    public boolean stillValid(@NotNull Player player) {
        return ChequeTableScreenHandler.stillValid((ContainerLevelAccess)this.context, (Player)player, (Block)((Block)NeeBlocks.CHEQUE_TABLE.get()));
    }

    public void removed(@NotNull Player player) {
        super.removed(player);
        this.clearContainer(player, this.coins);
        this.clearContainer(player, this.chequesInput);
    }

    public void checkIn(Player player) {
        ItemStack emptyCheque = this.chequesInput.getItem(0);
        if (!emptyCheque.is((Item)NeeItems.CHEQUE.get()) || ((ChequeComponent)emptyCheque.getOrDefault(NeeDataComponents.CHEQUE, (Object)ChequeComponent.EMPTY)).value() > 0) {
            return;
        }
        this.chequesOutput.setItem(0, ChequeItem.create(CoinItem.calculateValue(this.coins), player.getGameProfile().getName()));
        emptyCheque.shrink(1);
        this.coins.clearContent();
        ScreenHandlerUtils.playCheckedSound(this.context);
    }

    public void checkOut(Player player) {
        ItemStack cheque = this.chequesInput.getItem(0);
        if (!cheque.is((Item)NeeItems.CHEQUE.get()) || !cheque.has(NeeDataComponents.CHEQUE)) {
            return;
        }
        int value = ChequeItem.getValue(cheque);
        for (int i = 0; i < this.coins.getContainerSize(); ++i) {
            CoinItem coinItem;
            Item item;
            ItemStack stack = this.coins.getItem(i);
            while ((item = stack.getItem()) instanceof CoinItem && value >= (coinItem = (CoinItem)item).getValue() && stack.getCount() < stack.getMaxStackSize()) {
                stack.grow(1);
                value -= coinItem.getValue();
            }
        }
        int j = 0;
        List<ItemStack> remains = CoinItem.calculateCoins(value);
        for (int i = 0; i < this.coins.getContainerSize() && j < remains.size(); ++i) {
            if (!this.coins.getItem(i).isEmpty()) continue;
            this.coins.setItem(i, remains.get(j));
            ++j;
        }
        while (j < remains.size()) {
            player.getInventory().placeItemBackInInventory(remains.get(j));
            ++j;
        }
        cheque.shrink(1);
        ScreenHandlerUtils.playCheckedSound(this.context);
    }
}

