/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.random.economy.screen.handler;

import com.iafenvoy.random.economy.registry.NeeBlocks;
import com.iafenvoy.random.economy.registry.NeeScreenHandlers;
import com.iafenvoy.random.economy.screen.ScreenHandlerUtils;
import com.iafenvoy.random.economy.screen.inventory.ImplementedInventory;
import com.iafenvoy.random.economy.screen.slot.InputPredicateSlot;
import com.iafenvoy.random.economy.screen.slot.TakeOnlySlotWithCallback;
import com.iafenvoy.random.economy.trade.CoinExchangeHolder;
import com.iafenvoy.random.economy.util.ThingWithPrice;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExchangeStationScreenHandler
extends AbstractContainerMenu {
    private final Container inputs = ImplementedInventory.of((NonNullList<ItemStack>)NonNullList.withSize((int)1, (Object)ItemStack.EMPTY), () -> this.slotsChanged(null));
    private final Container outputs = new SimpleContainer(2);
    private final ContainerLevelAccess context;
    @Nullable
    private CoinExchangeHolder currentHolder = null;

    public ExchangeStationScreenHandler(int syncId, Inventory playerInventory) {
        this(syncId, playerInventory, ContainerLevelAccess.NULL);
    }

    public ExchangeStationScreenHandler(int syncId, Inventory playerInventory, ContainerLevelAccess context) {
        super((MenuType)NeeScreenHandlers.EXCHANGE_STATION.get(), syncId);
        int i;
        this.context = context;
        this.addSlot(new InputPredicateSlot(this.inputs, 0, 80, 20, stack -> stack.getItem() instanceof ThingWithPrice));
        this.addSlot(new TakeOnlySlotWithCallback(this, this.outputs, 0, 22, 20, amount -> {
            if (this.currentHolder == null) {
                return;
            }
            int ratio = this.currentHolder.leftRatio();
            this.inputs.getItem(0).shrink(amount / ratio);
            ScreenHandlerUtils.playCoinsSound(this.context);
        }));
        this.addSlot(new TakeOnlySlotWithCallback(this, this.outputs, 1, 138, 20, amount -> {
            if (this.currentHolder == null) {
                return;
            }
            int ratio = this.currentHolder.rightRatio();
            this.inputs.getItem(0).shrink(amount * ratio);
            ScreenHandlerUtils.playCoinsSound(this.context);
        }));
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, i * 18 + 51));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 109));
        }
    }

    public void slotsChanged(@NotNull Container inventory) {
        ItemStack in = this.inputs.getItem(0);
        this.currentHolder = CoinExchangeHolder.get(in.getItem());
        this.outputs.setItem(0, this.currentHolder == null ? ItemStack.EMPTY : this.currentHolder.parseLeft(in));
        this.outputs.setItem(1, this.currentHolder == null ? ItemStack.EMPTY : this.currentHolder.parseRight(in));
        super.slotsChanged(inventory);
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int slot) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot2 = (Slot)this.slots.get(slot);
        if (slot2.hasItem()) {
            ItemStack itemStack2 = slot2.getItem();
            itemStack = itemStack2.copy();
            if (slot < 3) {
                if (!this.moveItemStackTo(itemStack2, 3, this.slots.size(), true)) {
                    return ItemStack.EMPTY;
                }
                slot2.onTake(player, itemStack);
            } else if (!this.moveItemStackTo(itemStack2, 0, 1, false)) {
                return ItemStack.EMPTY;
            }
            if (itemStack2.isEmpty()) {
                slot2.setByPlayer(ItemStack.EMPTY);
            } else {
                slot2.setChanged();
            }
            this.slotsChanged(this.inputs);
        }
        return itemStack;
    }

    public boolean stillValid(@NotNull Player player) {
        return ExchangeStationScreenHandler.stillValid((ContainerLevelAccess)this.context, (Player)player, (Block)((Block)NeeBlocks.EXCHANGE_STATION.get()));
    }

    public void removed(@NotNull Player player) {
        super.removed(player);
        this.clearContainer(player, this.inputs);
    }
}

