/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.random.economy.screen.handler;

import com.iafenvoy.random.economy.registry.NeeBlocks;
import com.iafenvoy.random.economy.registry.NeeScreenHandlers;
import com.iafenvoy.random.economy.screen.InventoryUtil;
import com.iafenvoy.random.economy.screen.ScreenHandlerUtils;
import com.iafenvoy.random.economy.screen.slot.DisplayOnlySlot;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class SystemStationCustomerScreenHandler
extends AbstractContainerMenu {
    private final Container left;
    private final Container right;
    private final ContainerLevelAccess context;

    public SystemStationCustomerScreenHandler(int syncId, Inventory playerInventory) {
        this(syncId, playerInventory, (Container)new SimpleContainer(12), (Container)new SimpleContainer(12), ContainerLevelAccess.NULL);
    }

    public SystemStationCustomerScreenHandler(int syncId, Inventory playerInventory, Container left, Container right, ContainerLevelAccess context) {
        super((MenuType)NeeScreenHandlers.SYSTEM_STATION_CUSTOMER.get(), syncId);
        int j;
        int i;
        SystemStationCustomerScreenHandler.checkContainerSize((Container)left, (int)12);
        SystemStationCustomerScreenHandler.checkContainerSize((Container)right, (int)12);
        this.left = left;
        this.right = right;
        this.context = context;
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 4; ++j) {
                this.addSlot(new DisplayOnlySlot(this.left, j + i * 4, 8 + j * 18, 18 + i * 18));
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 4; ++j) {
                this.addSlot(new DisplayOnlySlot(this.right, j + i * 4, 98 + j * 18, 18 + i * 18));
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 142));
        }
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int slot) {
        return ItemStack.EMPTY;
    }

    public boolean stillValid(@NotNull Player player) {
        return SystemStationCustomerScreenHandler.stillValid((ContainerLevelAccess)this.context, (Player)player, (Block)((Block)NeeBlocks.SYSTEM_STATION.get()));
    }

    public void trade(Player player) {
        Inventory inventory = player.getInventory();
        if (!InventoryUtil.hasAllItems((Container)inventory, this.left)) {
            player.sendSystemMessage((Component)Component.translatable((String)"screen.random_economy.failure.no_enough_money"));
            return;
        }
        InventoryUtil.removeItems((Container)inventory, this.left);
        InventoryUtil.insertItems((Container)inventory, this.right);
        ScreenHandlerUtils.playCheckedSound(this.context);
    }
}

