/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.random.economy.screen.handler;

import com.iafenvoy.random.economy.registry.NeeScreenHandlers;
import com.iafenvoy.random.economy.screen.slot.DisplayOnlySlot;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TradeCommandScreenHandler
extends AbstractContainerMenu {
    private final Container left;
    private final Container right;
    private final Component anotherPlayerName;

    public TradeCommandScreenHandler(int syncId, Inventory playerInventory, RegistryFriendlyByteBuf buf) {
        this(syncId, playerInventory, (Container)new SimpleContainer(20), (Container)new SimpleContainer(20), (Component)ComponentSerialization.STREAM_CODEC.decode((Object)buf));
    }

    public TradeCommandScreenHandler(int syncId, Inventory playerInventory, Container left, Container right, Component anotherPlayerName) {
        super((MenuType)NeeScreenHandlers.TRADE_COMMAND.get(), syncId);
        int k;
        int j;
        TradeCommandScreenHandler.checkContainerSize((Container)left, (int)20);
        TradeCommandScreenHandler.checkContainerSize((Container)right, (int)20);
        this.left = left;
        this.right = right;
        this.anotherPlayerName = anotherPlayerName;
        for (j = 0; j < 5; ++j) {
            for (k = 0; k < 4; ++k) {
                this.addSlot(new Slot(this.left, k + j * 4, 8 + k * 18, 18 + j * 18));
            }
        }
        for (j = 0; j < 5; ++j) {
            for (k = 0; k < 4; ++k) {
                this.addSlot(new DisplayOnlySlot(this.right, k + j * 4, 98 + k * 18, 18 + j * 18));
            }
        }
        for (j = 0; j < 3; ++j) {
            for (k = 0; k < 9; ++k) {
                this.addSlot(new Slot((Container)playerInventory, k + j * 9 + 9, 8 + k * 18, 140 + j * 18));
            }
        }
        for (j = 0; j < 9; ++j) {
            this.addSlot(new Slot((Container)playerInventory, j, 8 + j * 18, 198));
        }
    }

    @Nullable
    public Component getAnotherPlayerName() {
        return this.anotherPlayerName;
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int slot) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot2 = (Slot)this.slots.get(slot);
        if (slot2.hasItem()) {
            ItemStack itemStack2 = slot2.getItem();
            itemStack = itemStack2.copy();
            if (slot < this.left.getContainerSize()) {
                if (!this.moveItemStackTo(itemStack2, this.left.getContainerSize() + this.right.getContainerSize(), this.slots.size(), true)) {
                    return ItemStack.EMPTY;
                }
                slot2.onTake(player, itemStack);
            } else if (!this.moveItemStackTo(itemStack2, 0, this.left.getContainerSize(), false)) {
                return ItemStack.EMPTY;
            }
            if (itemStack2.isEmpty()) {
                slot2.setByPlayer(ItemStack.EMPTY);
            } else {
                slot2.setChanged();
            }
        }
        return itemStack;
    }

    public boolean stillValid(@NotNull Player player) {
        return true;
    }
}

