/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.random.economy.screen.handler;

import com.iafenvoy.random.economy.registry.NeeBlocks;
import com.iafenvoy.random.economy.registry.NeeScreenHandlers;
import com.iafenvoy.random.economy.screen.slot.FakeItemSlot;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public class TradeStationOwnerScreenHandler
extends AbstractContainerMenu {
    private final Container left;
    private final Container right;
    private final Container inventory;
    private final ContainerLevelAccess context;

    public TradeStationOwnerScreenHandler(int syncId, Inventory playerInventory) {
        this(syncId, playerInventory, (Container)new SimpleContainer(12), (Container)new SimpleContainer(12), (Container)new SimpleContainer(21), (Container)new SimpleContainer(1), ContainerLevelAccess.NULL);
    }

    public TradeStationOwnerScreenHandler(int syncId, Inventory playerInventory, Container left, Container right, Container inventory, Container display, ContainerLevelAccess context) {
        super((MenuType)NeeScreenHandlers.TRADE_STATION_OWNER.get(), syncId);
        int j;
        int i;
        TradeStationOwnerScreenHandler.checkContainerSize((Container)left, (int)12);
        TradeStationOwnerScreenHandler.checkContainerSize((Container)right, (int)12);
        TradeStationOwnerScreenHandler.checkContainerSize((Container)inventory, (int)21);
        TradeStationOwnerScreenHandler.checkContainerSize((Container)display, (int)1);
        this.left = left;
        this.right = right;
        this.inventory = inventory;
        this.context = context;
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 4; ++j) {
                this.addSlot(new FakeItemSlot(this, this.left, j + i * 4, 8 + j * 18, 16 + i * 18));
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 4; ++j) {
                this.addSlot(new FakeItemSlot(this, this.right, j + i * 4, 98 + j * 18, 16 + i * 18));
            }
        }
        this.addSlot(new FakeItemSlot(this, display, 0, 152, 72));
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 7; ++j) {
                this.addSlot(new Slot(this.inventory, j + i * 7, 8 + j * 18, 72 + i * 18));
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)playerInventory, j + i * 9 + 9, 8 + j * 18, 140 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)playerInventory, i, 8 + i * 18, 198));
        }
    }

    @NotNull
    public ItemStack quickMoveStack(@NotNull Player player, int slot) {
        ItemStack itemStack = ItemStack.EMPTY;
        Slot slot2 = (Slot)this.slots.get(slot);
        if (slot2.hasItem()) {
            ItemStack itemStack2 = slot2.getItem();
            itemStack = itemStack2.copy();
            int fake = this.left.getContainerSize() + this.right.getContainerSize() + 1;
            if (fake <= slot && slot < fake + this.inventory.getContainerSize() ? !this.moveItemStackTo(itemStack2, fake + this.inventory.getContainerSize(), this.slots.size(), true) : !this.moveItemStackTo(itemStack2, fake, fake + this.inventory.getContainerSize(), false)) {
                return ItemStack.EMPTY;
            }
            if (itemStack2.isEmpty()) {
                slot2.setByPlayer(ItemStack.EMPTY);
            } else {
                slot2.setChanged();
            }
        }
        return itemStack;
    }

    public boolean stillValid(@NotNull Player player) {
        return TradeStationOwnerScreenHandler.stillValid((ContainerLevelAccess)this.context, (Player)player, (Block)((Block)NeeBlocks.TRADE_STATION.get()));
    }
}

