/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.random.economy.screen.inventory;

import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public interface ImplementedInventory
extends Container {
    public static ImplementedInventory of(NonNullList<ItemStack> items) {
        return () -> items;
    }

    public static ImplementedInventory of(final NonNullList<ItemStack> items, final Runnable onDirty) {
        return new ImplementedInventory(){

            @Override
            public NonNullList<ItemStack> getItems() {
                return items;
            }

            @Override
            public void setChanged() {
                ImplementedInventory.super.setChanged();
                onDirty.run();
            }
        };
    }

    public static ImplementedInventory ofSize(int size) {
        return ImplementedInventory.of((NonNullList<ItemStack>)NonNullList.withSize((int)size, (Object)ItemStack.EMPTY));
    }

    public NonNullList<ItemStack> getItems();

    default public int getContainerSize() {
        return this.getItems().size();
    }

    default public boolean isEmpty() {
        for (int i = 0; i < this.getContainerSize(); ++i) {
            ItemStack stack = this.getItem(i);
            if (stack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    default public ItemStack getItem(int slot) {
        return (ItemStack)this.getItems().get(slot);
    }

    @NotNull
    default public ItemStack removeItem(int slot, int count) {
        ItemStack result = ContainerHelper.removeItem(this.getItems(), (int)slot, (int)count);
        if (!result.isEmpty()) {
            this.setChanged();
        }
        return result;
    }

    @NotNull
    default public ItemStack removeItemNoUpdate(int slot) {
        return ContainerHelper.takeItem(this.getItems(), (int)slot);
    }

    default public void setItem(int slot, @NotNull ItemStack stack) {
        this.getItems().set(slot, (Object)stack);
        if (stack.getCount() > stack.getMaxStackSize()) {
            stack.setCount(stack.getMaxStackSize());
        }
    }

    default public void clearContent() {
        this.getItems().clear();
    }

    default public void setChanged() {
    }

    default public boolean stillValid(@NotNull Player player) {
        return true;
    }
}

