/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.random.economy.trade;

import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public record CoinExchangeHolder(Item leftItem, int leftRatio, Item rightItem, int rightRatio) {
    private static final Map<Item, CoinExchangeHolder> HOLDERS = new LinkedHashMap<Item, CoinExchangeHolder>();

    public static void register(Item item, CoinExchangeHolder holder) {
        HOLDERS.put(item, holder);
    }

    @Nullable
    public static CoinExchangeHolder get(Item item) {
        return HOLDERS.get(item);
    }

    public ItemStack parseLeft(ItemStack source) {
        return new ItemStack((ItemLike)this.leftItem, this.leftRatio);
    }

    public ItemStack parseRight(ItemStack source) {
        if (source.getCount() < this.rightRatio) {
            return ItemStack.EMPTY;
        }
        return new ItemStack((ItemLike)this.rightItem);
    }
}

