/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.random.economy.trade;

import com.iafenvoy.random.economy.network.payload.TradeStateChangePayload;
import com.iafenvoy.random.economy.screen.InventoryUtil;
import com.iafenvoy.random.economy.screen.handler.TradeCommandScreenHandler;
import com.iafenvoy.random.economy.trade.TradeMessageType;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public final class PlayerExchangeHolder {
    private static final List<PlayerExchangeHolder> PENDING = new LinkedList<PlayerExchangeHolder>();
    private static final Map<ServerPlayer, PlayerExchangeHolder> HOLDER_BY_PLAYER = new HashMap<ServerPlayer, PlayerExchangeHolder>();
    private static final Map<ServerPlayer, Single> SINGLE_BY_PLAYER = new HashMap<ServerPlayer, Single>();
    private final Single user1;
    private final Single user2;

    private PlayerExchangeHolder(ServerPlayer user1, ServerPlayer user2) {
        this.user1 = new Single(user1, (Container)new SimpleContainer(20));
        this.user2 = new Single(user2, (Container)new SimpleContainer(20));
        PENDING.add(this);
        HOLDER_BY_PLAYER.put(user1, this);
        HOLDER_BY_PLAYER.put(user2, this);
        SINGLE_BY_PLAYER.put(user1, this.user1);
        SINGLE_BY_PLAYER.put(user2, this.user2);
    }

    public void onCancel(Component canceller) {
        InventoryUtil.insertItems((Container)this.user1.player.getInventory(), this.user1.inventory);
        InventoryUtil.insertItems((Container)this.user2.player.getInventory(), this.user2.inventory);
        this.user1.player.sendSystemMessage((Component)Component.translatable((String)"command.random_economy.trade_cancel", (Object[])new Object[]{canceller}));
        this.user2.player.sendSystemMessage((Component)Component.translatable((String)"command.random_economy.trade_cancel", (Object[])new Object[]{canceller}));
        this.close();
    }

    public void onConfirm() {
        InventoryUtil.insertItems((Container)this.user1.player.getInventory(), this.user2.inventory);
        InventoryUtil.insertItems((Container)this.user2.player.getInventory(), this.user1.inventory);
        this.user1.player.sendSystemMessage((Component)Component.translatable((String)"command.random_economy.trade_success"));
        this.user2.player.sendSystemMessage((Component)Component.translatable((String)"command.random_economy.trade_success"));
        this.close();
    }

    public void close() {
        PENDING.remove(this);
        this.closeInternal();
    }

    private void closeInternal() {
        HOLDER_BY_PLAYER.remove(this.user1.player);
        HOLDER_BY_PLAYER.remove(this.user2.player);
        SINGLE_BY_PLAYER.remove(this.user1.player);
        SINGLE_BY_PLAYER.remove(this.user2.player);
        PlayerExchangeHolder.closeTradeScreen(this.user1.player);
        PlayerExchangeHolder.closeTradeScreen(this.user2.player);
    }

    public void checkTrade() {
        if (this.user1.accepted && this.user2.accepted) {
            this.onConfirm();
        }
    }

    public void openScreen() {
        this.openScreen(this.user1, this.user2);
        this.openScreen(this.user2, this.user1);
    }

    private void openScreen(final Single current, final Single another) {
        final Component anotherName = another.player.getDisplayName();
        current.player.openMenu(new MenuProvider(){

            @NotNull
            public Component getDisplayName() {
                return Component.translatable((String)"screen.random_economy.trade");
            }

            @NotNull
            public AbstractContainerMenu createMenu(int syncId, @NotNull Inventory inventory, @NotNull Player player) {
                return new TradeCommandScreenHandler(syncId, inventory, current.inventory, another.inventory, anotherName);
            }
        }, buf -> ComponentSerialization.STREAM_CODEC.encode(buf, (Object)anotherName));
    }

    private Single getAnother(Single self) {
        return self == this.user1 ? this.user2 : this.user1;
    }

    private boolean isIn(Single single) {
        return single == this.user1 || single == this.user2;
    }

    public static void closeTradeScreen(ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new TradeStateChangePayload(TradeMessageType.ANOTHER_CLOSE_SCREEN), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void sendAcceptState(ServerPlayer player, boolean accepted) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new TradeStateChangePayload(accepted ? TradeMessageType.ANOTHER_ACCEPT : TradeMessageType.ANOTHER_CANCEL_ACCEPT), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static void launchTrade(ServerPlayer user1, ServerPlayer user2) {
        new PlayerExchangeHolder(user1, user2).openScreen();
    }

    public static void onTradeStateChange(TradeStateChangePayload payload, IPayloadContext context) {
        Player player = context.player();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        PlayerExchangeHolder holder = HOLDER_BY_PLAYER.get(player2);
        Single single = SINGLE_BY_PLAYER.get(player2);
        if (holder == null || !holder.isIn(single)) {
            return;
        }
        Single another = holder.getAnother(single);
        TradeMessageType type = payload.message();
        switch (type) {
            case SELF_ACCEPT: {
                single.accepted = true;
                PlayerExchangeHolder.sendAcceptState(another.player, true);
                holder.checkTrade();
                break;
            }
            case SELF_CANCEL_ACCEPT: {
                single.accepted = false;
                PlayerExchangeHolder.sendAcceptState(another.player, false);
                break;
            }
            case SELF_CLOSE_SCREEN: {
                holder.onCancel((Component)single.player.getDisplayName().plainCopy().withStyle(ChatFormatting.RED));
            }
        }
    }

    private static class Single {
        private final ServerPlayer player;
        private final Container inventory;
        private boolean accepted;

        private Single(ServerPlayer player, Container inventory) {
            this.player = player;
            this.inventory = inventory;
        }
    }
}

