package dev.ngspace.ngsmcconfig.gui;

import java.io.File;
import java.net.URI;
import java.util.List;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_410;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_7842;
import org.jetbrains.annotations.Nullable;

import dev.ngspace.ngsmcconfig.api.NGSMCConfigCategory;

public abstract class AbstractNGSMCConfigScreen extends class_437 {
	
	protected class_437 parent;
	protected List<NGSMCConfigCategory> categories;
	protected NGSMCConfigOptionsListWidget container;
	protected boolean createContainer;
	protected boolean askBeforeUnsavedLeave;
	
	protected class_4185 saveButton;
	protected class_4185 backButton;
	protected class_4185 globalResetButton;
	protected class_4185 wikiButton;
	protected class_4185 configButton;
	protected class_7842 errorWidget;
	protected Runnable writeoperation;
	protected URI wikiUri;
	protected File configfile;
	
	protected AbstractNGSMCConfigScreen(class_437 parentScreen, List<NGSMCConfigCategory> categories, boolean c,
			Runnable writeoperation, URI wikiUri, File configfile) {
		super(class_2561.method_43470("NGSMCConfig"));
		this.categories = categories;
		this.parent = parentScreen;
		this.createContainer = c;
		this.writeoperation = writeoperation;
		this.wikiUri = wikiUri;
		this.configfile = configfile;
	}
	@Override
	protected void method_25426() {
		
		class_2561 error = getError();
		
		backButton = class_4185.method_46430(class_2561.method_43471("ngsmcconfig.back"), b->method_25419())
				.method_46434(0, 0, 30, 20)
				.method_46431();
		method_37063(backButton);
		
		saveButton = class_4185.method_46430(class_2561.method_43471("ngsmcconfig.save"), b->save())
				.method_46434(30, 0, 30, 20)
				.method_46431();
		saveButton.field_22763 = error==null;
		method_37063(saveButton);
		
		globalResetButton = class_4185.method_46430(class_2561.method_43471("ngsmcconfig.globalreset"), b->reset())
				.method_46434(field_22789-40, 0, 40, 20)
				.method_46431();

		if (configfile!=null) {
			configButton = class_4185.method_46430(class_2561.method_43471("ngsmcconfig.config"),
					b->class_156.method_668().method_672(configfile))
					.method_46434(field_22789-(wikiUri!=null?150:120), 0, 70, 20)
					.method_46431();
			method_37063(configButton);
		}
		
		if (wikiUri!=null) {
			wikiButton = class_4185.method_46430(class_2561.method_43471("ngsmcconfig.wiki"),
					b->class_156.method_668().method_673(wikiUri))
					.method_46434(field_22789-80, 0, 40, 20)
					.method_46431();
			method_37063(wikiButton);
		}
		method_37063(globalResetButton);
		
		errorWidget = new class_7842(error!=null?error:class_2561.method_43470(""), field_22793);
		errorWidget.method_48229(65, 0);
		errorWidget.method_55445(300, 20);
		errorWidget.method_46438(0xFF0000);
		errorWidget.method_48596();
		method_37063(errorWidget);
		
		if (createContainer) {
			int width = class_310.method_1551().method_22683().method_4486();
			int height = class_310.method_1551().method_22683().method_4502();
		
			container = new NGSMCConfigOptionsListWidget(class_310.method_1551(), width, height, 20);
			
			method_37063(container);
		}
	}

	protected void save() {
		for (var category : categories) {
			for (var option : category.options()) {
				option.save();
				option.edited = false;
			}
		}
		writeoperation.run();
	}
	protected void reset() {
		field_22787.method_1507(new class_410(b->{if (b) resetNoConf();field_22787.method_1507(this);},
				class_2561.method_43471("ngsmcconfig.confirmreset"),
				class_2561.method_43471("ngsmcconfig.confirmreset.text")));
	}
	protected void resetNoConf() {
		for (var category : categories) {
			for (var option : category.options()) {
				option.reset();
			}
		}
		save();
	}
	protected class_2561 getError() {
		for (var category : categories) {
			for (var option : category.options()) {
				var error = option.getError();
				if (error!=null)
					return error;
			}
		}
		return null;
	}
	protected boolean isEditedAndNotSaved() {
		for (var category : categories)
			for (var option : category.options())
				if (option.edited)
					return option.edited;
		return false;
	}
	
	@Override
	public void method_25419() {
		if (askBeforeUnsavedLeave&&isEditedAndNotSaved())
			field_22787.method_1507(new class_410(b->field_22787.method_1507(b?parent:this),
					class_2561.method_43471("ngsmcconfig.confirmunsavedexit"),
					class_2561.method_43471("ngsmcconfig.confirmunsavedexit.text")));
		else
			this.field_22787.method_1507(this.parent);
	}
	
    @Override
    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
		
		class_2561 error = getError();
		
		saveButton.field_22763 = error==null;
		errorWidget.method_25355(error!=null?error:class_2561.method_43470(""));
		
        if (container!=null)
        	container.method_25394(graphics, mouseX, mouseY, partialTick);
        super.method_25394(graphics, mouseX, mouseY, partialTick);
    }
    @Override
    public boolean method_25430(@Nullable class_2583 style) {
        if (style == null) return false;
        return super.method_25430(style);
    }
}
