package dev.ngspace.ngsmcconfig.options;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_2561;
import dev.ngspace.ngsmcconfig.gui.NGSMCConfigEntry;

public abstract class AbstractNGSMCConfigOption<T> {

	public T defaultValue;
	public T value;
	public class_2561 text;
	public Consumer<T> saveOperation;
	public Function<T, class_2561> validator;
	public boolean edited;

	protected AbstractNGSMCConfigOption(T defaultValue, T value, class_2561 text, Consumer<T> saveOperation,
			Function<T, class_2561> validator) {
		this.defaultValue = defaultValue;
		this.value = value;
		this.text = text;
		this.saveOperation = saveOperation;
		this.validator = validator;
	}
	
	public void save() {
		saveOperation.accept(value);
	}
	
	public class_2561 getError() {
		return validator==null ? null : validator.apply(value);
	}
	
	public abstract NGSMCConfigEntry buildEntry();

	public abstract void reset();

	public boolean isDefault() {
		return Objects.equals(value, defaultValue);
	}
}
