package dev.ngspace.ngsmcconfig.options;

import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_2561;
import dev.ngspace.ngsmcconfig.api.AbstractNGSMCConfigOptionBuilder;

public class IntNGSMCConfigOption extends AbstractTextFieldNGSMCConfigOption<Integer> {

	protected boolean validnum = true;
	protected String invalidnum;
	
	protected IntNGSMCConfigOption(Integer defaultValue, Integer value, class_2561 text, Consumer<Integer> saveOperation,
			Function<Integer, class_2561> validator) {
		super(defaultValue, value, text, saveOperation, validator);
		this.validator = val->{
			if (!validnum)
				return class_2561.method_43470("Invalid number: \"" + invalidnum + "\"");
			return validator==null?null:validator.apply(val);
		};
		textfilter = val -> {
			boolean passfilter = val.chars().allMatch(c->Character.isDigit(c)||c=='-');
			if (passfilter) {
				try {
					this.value = Integer.parseInt(val);
					validnum = true;
				} catch (NumberFormatException e) {
					validnum = false;
					invalidnum = val;
				}
			}
			return passfilter;
		};
	}
	
	public static AbstractNGSMCConfigOptionBuilder<Integer> builder(int value, class_2561 name) {
		return new AbstractNGSMCConfigOptionBuilder<Integer>(value, name) {
			@Override public AbstractNGSMCConfigOption<Integer> build() {
				return new IntNGSMCConfigOption(defaultValue, value, name, saveOperation, validator);
			}
		};
	}
}
