package io.github.ngspace.hudder.data_management;

import java.util.HashMap;
import net.minecraft.class_1887;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9304;
import net.minecraft.class_9323;
import net.minecraft.class_9334;
import io.github.ngspace.hudder.utils.ValueGetter;

@SuppressWarnings("unused")
public class ComponentsData extends HashMap<String, Object> {
	
	private static final long serialVersionUID = 229002063971831208L;
	
	public static Object getObject(String key, class_9323 comp) {
		
		return switch (key.toLowerCase()) {
			
			/* Text Objects */
			case "custom_name", "item_name": {
				class_2561 t = (class_2561) comp.method_57829(class_7923.field_49658.method_10223(class_2960.method_60656(key)));
				
				yield t!=null ? t.getString() : null;
			}
			
			/* Primitives */
			case "repair_cost", "damage", "max_damage", "max_stack_size", "enchantment_glint_override":
				yield comp.method_57829(class_7923.field_49658.method_10223(class_2960.method_60656(key)));
			
//			case "mining_speed": yield comp.get(DataComponentTypes.TOOL).defaultMiningSpeed();

			case "trim": yield comp.method_57829(class_9334.field_49607) !=null ? new Object() {
				String material = comp.method_57829(class_9334.field_49607).method_48431().comp_349().comp_1208();
				String pattern = comp.method_57829(class_9334.field_49607).method_48424().comp_349().comp_1213().toString();
			} : null;

			case "lore": yield comp.method_57829(class_9334.field_49632) !=null ? 
					comp.method_57829(class_9334.field_49632).comp_2401() : null;
			case "rarity": yield comp.method_57829(class_9334.field_50073) !=null ? 
					comp.method_57829(class_9334.field_50073).toString() : null;
			
			case "unbreakable": yield comp.method_57829(class_9334.field_49630);
			
			case "custom_data": yield String.valueOf(comp.method_57829(class_9334.field_49628));
			
			case "enchantments": {
				var d = comp.method_57829(class_9334.field_49633);
				if (d==null) yield null;
				yield new EnchantmentInfo(d);
			}
			
			default: yield null;
		};
	}
	
	public static class EnchantmentInfo implements ValueGetter {
		private class_9304 d;
		public EnchantmentInfo(class_9304 r) {this.d=r;}
		@Override public Object get(String n) {
			for (var e : d.method_57534())
				if (getName(e.comp_349().comp_2686()).equals(n))
					return new LevelHolder(d,e);
			return null;
		}
		@Override public String toString() {
			String str = "{";
			for (var e : d.method_57534()) {
				str += getName(e.comp_349().comp_2686());
				str += ", ";
			}
			if (str.length()!=1) str = str.substring(0,str.length()-2);
			return str + "}";
		}
		private static String getName(class_2561 description) {
			String s = ((class_2588) description.method_10851()).method_11022();
			String[] ss = s.split("\\.");
			return ss[ss.length-1];
		}
	}
	public static class LevelHolder {
		public int level;
		private class_1887 e;
		public LevelHolder(class_9304 d, class_6880<class_1887> e) {
			this.e = e.comp_349();
			this.level = d.method_57536(e);
		}
		@Override public String toString() {return EnchantmentInfo.getName(e.comp_2686()) + " " + level;}
	}
}
