package io.github.ngspace.hudder.data_management;

import java.util.Calendar;
import java.util.Queue;
import net.minecraft.class_1132;
import net.minecraft.class_1309;
import net.minecraft.class_1496;
import net.minecraft.class_1944;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_5134;
import net.minecraft.class_746;
import io.github.ngspace.hudder.Hudder;
import io.github.ngspace.hudder.main.config.HudderConfig;
import io.github.ngspace.hudder.mixin.ParticleManagerAccessor;
import io.github.ngspace.hudder.v2runtime.V2Runtime;

public class NumberData {private NumberData() {}
	static final double MB = 1024d*1024d;
    static final Runtime runtime = Runtime.getRuntime();
	
	public static Object getNumber(String key) {
		class_310 ins = class_310.method_1551();
		class_746 p = ins.field_1724;
		class_4184 c = ins.field_1773.method_19418();
		int fps = Advanced.getFPS(ins);
		HudderConfig config = Hudder.config;
		
		return switch(key) {
			
			/* Performance */
			case "fps": yield (double) fps;
			case "avgfps","avg_fps": yield (double) Advanced.getAverageFPS();
			case "minfps","min_fps": yield (double) Advanced.getMinimumFPS();
			case "maxfps","max_fps": yield (double) Advanced.getMaximumFPS();
			case "ping": yield (double) ins.method_1562().method_2874(p.method_5477().getString()).method_2959();
			case "tps": yield (double) getTPS(ins);
			
			case "gpu_d", "dgpu": yield Advanced.gpuUsage;
			case "gpu": yield (double) ((int)Advanced.gpuUsage);
			case "cpu_d": yield Advanced.CPU.get()* 100d;
			case "cpu": yield (double) (int) (Advanced.CPU.get()* 100d);
			
			case "delta": yield (double) Advanced.delta;
			
			
			/* Memory */
			case "totalmemory","maxmemory","totalram","maxram": yield runtime.maxMemory() / MB;
			case "usedmemory","usedram": yield (runtime.totalMemory() - runtime.freeMemory()) / MB;
			case "freememory","freeram": yield runtime.freeMemory() / MB;
			case "usedmemory_percentage","usedram_percentage":
				double usedmem = ((double)runtime.totalMemory() - (double)runtime.freeMemory()) / MB;
				double totalmem = (runtime.maxMemory())/MB;
				yield (double) ((int)(usedmem/totalmem*100));
			case "freememory_percentage","freeram_percentage": yield (double) runtime.freeMemory() / runtime.maxMemory();
			
			
			
			/* Time */
			case "time": yield (double) System.currentTimeMillis();
			case "milliseconds": yield (double) Calendar.getInstance().get(Calendar.MILLISECOND);
			case "seconds": yield (double) Calendar.getInstance().get(Calendar.SECOND);
			case "minutes": yield (double) Calendar.getInstance().get(Calendar.MINUTE);
			case "hour": yield (double) Calendar.getInstance().get(Calendar.HOUR_OF_DAY);
			case "day": yield (double) Calendar.getInstance().get(Calendar.DAY_OF_MONTH);
			case "month": yield (double) Calendar.getInstance().get(Calendar.MONTH);
			case "year": yield (double) Calendar.getInstance().get(Calendar.YEAR);
			
			
			
			/* Food and health */
			case "saturation": yield (double) p.method_7344().method_7589();
			case "hunger": yield (double) p.method_7344().method_7586();
			case "health", "hp": yield (double) p.method_6032();
			case "maxhealth", "maxhp": yield (double) p.method_6063();
			case "absorption": yield (double) p.method_6067();
			case "maxabsorption": yield (double) p.method_52541();



			/* Mount information */
			case "mount_health", "mount_hp": yield (p.method_5854() instanceof class_1309 entity) ? (double) entity.method_6032() : V2Runtime.NULL;
			case "mount_maxhealth", "mount_maxhp": yield (p.method_5854() instanceof class_1309 entity) ? (double) entity.method_6063() : V2Runtime.NULL;
			case "mount_speed": yield (p.method_5854() instanceof class_1309 entity) ? entity.method_5996(class_5134.field_23719).method_6201() : V2Runtime.NULL;
			case "mount_jump_strength": yield (p.method_5854() instanceof class_1309 entity) ? entity.method_5996(class_5134.field_23728).method_6201() : V2Runtime.NULL;
			case "mount_jump_scale": yield (p.method_5854() instanceof class_1496) ? (double) p.method_3151() : V2Runtime.NULL;
			case "mount_armor": yield (p.method_5854() instanceof class_1496) ? (double) ((class_1496) p.method_5854()).method_6096() : V2Runtime.NULL;
			case "mount_jump_cooldown": yield (p.method_5854() instanceof class_1496) ? (double) ((class_1496) p.method_5854()).method_45327() : V2Runtime.NULL;



			/* Other Player related information */
			case "selectedslot": yield (double) p.method_31548().field_7545;
			case "xplevel": yield (double) p.field_7520;
			case "xp": yield (double) p.field_7495;
			case "armor": yield (double) p.method_6096();
			case "falldistance": yield p.field_6017;
			case "airbubbles": {
				yield (double) getCurrentAirSupplyBubble(Math.clamp(p.method_5669(), 0, p.method_5748()), p.method_5748(), 0);
			}
			case "maxairbubbles":  {
				yield (double) getCurrentAirSupplyBubble(p.method_5748(), p.method_5748(), 0);
			}

			case "playerspeed": {
				var ent = p.method_5854() == null ? p : p.method_5854();

			    double speed = (Math.sqrt(Math.pow(ent.method_23317() - ent.field_6038, 2) +
			    		Math.pow(ent.method_23318() - ent.field_5971 , 2) + Math.pow(ent.method_23321() - ent.field_5989 , 2)) * 20);
			    yield speed;
			}
			case "horizontal_playerspeed": {
				var ent = p.method_5854() == null ? p : p.method_5854();

			    double speed = (Math.sqrt(Math.pow(ent.method_23317() - ent.field_6038, 2) + Math.pow(ent.method_23321() - ent.field_5989 , 2)) * 20);
			    yield speed;
			}


			
			/* Player position */
			case "dxpos","dx": yield p.method_23317();
			case "dypos","dy": yield p.method_23318();
			case "dzpos","dz": yield p.method_23321();
			case "xpos","x": yield (double) p.method_31477();
			case "ypos","y": yield (double) p.method_31478();
			case "zpos","z": yield (double) p.method_31479();



			/* Camera position */
			case "cam_dxpos": yield c.method_19326().field_1352;
			case "cam_dypos": yield c.method_19326().field_1351;
			case "cam_dzpos": yield c.method_19326().field_1350;
			case "cam_xpos": yield (double) c.method_19328().method_10263();
			case "cam_ypos": yield (double) c.method_19328().method_10264();
			case "cam_zpos": yield (double) c.method_19328().method_10260();
			
			
			
			/* Chunk information */
			case "subchunkx": yield (double) (p.method_31477() & 0xF);
			case "subchunky": yield (double) (p.method_31478() & 0xF);
			case "subchunkz": yield (double) (p.method_31479() & 0xF);
			case "chunkx": yield (double) p.method_31476().field_9181;
			case "chunkz": yield (double) p.method_31476().field_9180;



			/* Camera chunk information */
			case "cam_subchunkx": yield (double) (c.method_19328().method_10263() & 0xF);
			case "cam_subchunky": yield (double) (c.method_19328().method_10264() & 0xF);
			case "cam_subchunkz": yield (double) (c.method_19328().method_10260() & 0xF);
			case "cam_chunkx": yield (double) (c.method_19328().method_10263() >> 4);
			case "cam_chunkz": yield (double) (c.method_19328().method_10260() >> 4);



			/* Player roation */
			// Pitch
			case "dpitch": yield (double) p.method_36455();
			case "pitch": yield (double) (int) p.method_36455();
			// Yaw
			case "dyaw": {
				float yaw = p.method_5791();
				if (yaw<0) yield (double) (360d+(yaw % 360d));
				yield yaw % 360d;
			}
			case "yaw":  {
				int yaw = (int) p.method_5791();
				if (yaw<0) yield (double) (360+(yaw % 360));
				yield yaw % 360d;
			}
			// F3 yaw
			case "f3_dyaw": yield (double) class_3532.method_15393(p.method_5791());
			case "f3_yaw": yield (double) (int) class_3532.method_15393(p.method_5791());



			/* Camera roation */
			// Pitch
			case "cam_dpitch": yield (double) c.method_19329();
			case "cam_pitch": yield (double) (int) c.method_19329();
			// Yaw
			case "cam_dyaw": {
				float yaw = c.method_19330();
				if (yaw<0) yield (double) (360d+(yaw % 360d));
				yield yaw % 360d;
			}
			case "cam_yaw":  {
				int yaw = (int) c.method_19330();
				if (yaw<0) yield (double) (360+(yaw % 360));
				yield yaw % 360d;
			}
			// F3 yaw
			case "cam_f3_dyaw": yield (double) class_3532.method_15393(c.method_19330());
			case "cam_f3_yaw": yield (double) (int) class_3532.method_15393(c.method_19330());



			/* World Rendering */
//			case "entites", "entities": yield (double) ((WorldRendererAccess)ins.levelRenderer).getRegularEntityCount();
			case "particles": yield (double) ((ParticleManagerAccessor)ins.field_1713)
				.getParticles().values().stream().mapToInt(Queue::size).sum();
			case "chunks": yield (double) ins.field_1769.method_3246();
			
			
			
			/* Light */
			/* At player */
			case "light": yield (double) ins.field_1687.method_22339(p.method_24515());
			case "blocklight", "block_light": yield (double) ins.field_1687.method_8314(class_1944.field_9282,p.method_24515());
			case "skylight", "sky_light": yield (double) ins.field_1687.method_8314(class_1944.field_9284,p.method_24515());
			/* At camera */
			case "cam_light": yield (double) ins.field_1687.method_22339(c.method_19328());
			case "cam_blocklight", "cam_block_light": yield (double) ins.field_1687.method_8314(class_1944.field_9282,c.method_19328());
			case "cam_skylight", "cam_sky_light": yield (double) ins.field_1687.method_8314(class_1944.field_9284,c.method_19328());
			
			
			
			/* World */
			case "worldtime", "world_time": yield (double) ins.field_1687.method_8532();
			case "daytime", "day_time": yield ins.field_1687.method_8532()/24000d;



			/* GUI rendering */
			case "width": yield (double) ins.method_22683().method_4486();
			case "height": yield (double) ins.method_22683().method_4502();
			case "guiscale": yield (double) ins.method_22683().method_4495();
			
			
			/* Hudder */
			case "scale": yield (double) config.scale;
			case "color": yield (double) config.color;
			case "yoffset": yield (double) config.yoffset;
			case "xoffset": yield (double) config.xoffset;
			case "lineheight": yield (double) config.lineHeight;
			case "methodbuffer": yield (double) config.methodBuffer;
			case "backgroundcolor": yield (double) config.backgroundcolor;
			
			
			
			case "rebeccapurple": yield (double) 0xFF663399;
			
			default: yield null;
		};
	}
	public static float getTPS(class_310 client) {
        class_1132 server = client.method_1576();
        return server == null ? -1f : server.method_54833().method_54748();
	}

	public static int getCurrentAirSupplyBubble(int i, int j, int k) {
		return class_3532.method_15386((float)((i + k) * 10) / (float)j);
	}
}
