package io.github.ngspace.hudder.utils.testing;

import static java.nio.charset.StandardCharsets.UTF_8;

import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.apache.commons.io.IOUtils;

import io.github.ngspace.hudder.Hudder;
import io.github.ngspace.hudder.compilers.abstractions.ATextCompiler;
import io.github.ngspace.hudder.main.config.HudderConfig;
import io.github.ngspace.hudder.utils.testing.HudderUnitTest.HudderUnitTestResult;

public class HudderUnitTester {
	public ATextCompiler compiler;
	public Map<String, HudderUnitTest> UnitTests = new HashMap<String, HudderUnitTest>();
	
	public HudderUnitTester(ATextCompiler compiler) {this.compiler=compiler;}
	
	public void load(InputStream inputStream) throws IOException {load(IOUtils.toString(inputStream, UTF_8));}
	
	public void load(String contents) {
	    String[] conds = ("\n"+contents).split("\\n\\n\\|\\|INPUT\\|\\|");
	    for (String st : conds) {
	    	if (st.isBlank()) continue;
	    	String[] content = st.split("\n",2);
	    	String[] inputandExpectation = content[1].split("\\n\\|\\|EXPECT\\|\\|\\n");
	    	if (UnitTests.containsKey(content[0]))
	    		Hudder.alert("Repeating key: " + content[0]);
	    	UnitTests.put(content[0], new HudderUnitTest(inputandExpectation[0], compiler, inputandExpectation[1]));
	    }
	    HudderUnitTestingCommand.UnitTestsSuggestionProvider.suggestions = new ArrayList<String>(UnitTests.keySet());
	}
	
	
	
	public HudderUnitTestResult test(HudderConfig info, String name) {return UnitTests.get(name).test(info);}
	
	
	
	public class_5250 testAll(HudderConfig config) {
		class_5250 result = class_2561.method_43470("All tests:\n");
		boolean failed = false;
		Instant start = Instant.now();
		Map<HudderUnitTestResult,String> failedtests = new HashMap<HudderUnitTestResult, String>();
		for (String name : UnitTests.keySet()) {
			var testresult = test(config, name);
			result.method_27693("\n").method_10852(testresult.toText(name));
			if (!testresult.isSucessful) {
				failed = true;
				failedtests.put(testresult, name);
			}
		}
		Instant end = Instant.now();
		if (failed) {
			result.method_10852(class_2561.method_43470("\n\nFailed the following tests: ").method_54663(0xff0000));
			for (var failedtest : failedtests.entrySet()) {
				result.method_27693("\n\n");
				result.method_10852(class_2561.method_43470(failedtest.getValue()).method_54663(0xff0000));
				result.method_27693(":");
				result.method_10852(failedtest.getKey().getFailureMessage());
			}
			result.method_10852(class_2561.method_43470(milliseconds(false, start, end, failedtests.size(), UnitTests.size())));
		} else result.method_10852(class_2561.method_43470(milliseconds(true, start, end, failedtests.size(), UnitTests.size())));
		return result;
	}

	private String milliseconds(boolean success, Instant start, Instant end, int failedcount, int testscount) {
		double v = Duration.between(start, end).toNanos()/1000000d;
		double res = (int) (v*1000);
		res/=1000;
		return "\n\n" + (success? "Successful, " : "") + "took "+ res + "ms. Passed "
				+ (testscount-failedcount) + "/" + testscount + " tests.";
	}
}