package io.github.ngspace.hudder.data_management;

import java.util.Calendar;
import java.util.Queue;
import net.minecraft.class_1132;
import net.minecraft.class_1297;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1944;
import net.minecraft.class_310;
import net.minecraft.class_746;
import io.github.ngspace.hudder.Hudder;
import io.github.ngspace.hudder.main.config.HudderConfig;
import io.github.ngspace.hudder.mixin.ParticleManagerAccessor;
import io.github.ngspace.hudder.mixin.WorldRendererAccess;

public class NumberData {private NumberData() {}
	static final double MB = 1024d*1024d;
    static final Runtime runtime = Runtime.getRuntime();
	
	public static Double getNumber(String key) {
		class_310 ins = class_310.method_1551();
		class_746 p = ins.field_1724;
		int fps = Advanced.getFPS(ins);
		HudderConfig config = Hudder.config;
		
		return switch(key) {
			
			/* Performance */
			case "fps": yield (double) fps;
			case "avgfps","avg_fps": yield (double) Advanced.getAverageFPS();
			case "minfps","min_fps": yield (double) Advanced.getMinimumFPS();
			case "maxfps","max_fps": yield (double) Advanced.getMaximumFPS();
			case "ping": yield (double) ins.method_1562().method_2874(p.method_5477().getString()).method_2959();
			case "tps": yield (double) getTPS(ins);
			
			case "gpu_d", "dgpu": yield Advanced.gpuUsage;
			case "gpu": yield (double) ((int)Advanced.gpuUsage);
			case "cpu_d": yield Advanced.CPU.get()* 100d;
			case "cpu": yield (double) (int) (Advanced.CPU.get()* 100d);
			
			case "delta": yield (double) Advanced.delta;
			
			
			/* Memory */
			case "totalmemory","maxmemory","totalram","maxram": yield runtime.maxMemory() / MB;
			case "usedmemory","usedram": yield (runtime.totalMemory() - runtime.freeMemory()) / MB;
			case "freememory","freeram": yield runtime.freeMemory() / MB;
			case "usedmemory_percentage","usedram_percentage":
				double usedmem = ((double)runtime.totalMemory() - (double)runtime.freeMemory()) / MB;
				double totalmem = (runtime.maxMemory())/MB;
				yield (double) ((int)(usedmem/totalmem*100));
			case "freememory_percentage","freeram_percentage": yield (double) runtime.freeMemory() / runtime.maxMemory();
			
			
			
			/* time */
			case "time": yield (double) System.currentTimeMillis();
			case "milliseconds": yield (double) Calendar.getInstance().get(Calendar.MILLISECOND);
			case "seconds": yield (double) Calendar.getInstance().get(Calendar.SECOND);
			case "minutes": yield (double) Calendar.getInstance().get(Calendar.MINUTE);
			case "hour": yield (double) Calendar.getInstance().get(Calendar.HOUR_OF_DAY);
			case "day": yield (double) Calendar.getInstance().get(Calendar.DAY_OF_MONTH);
			case "month": yield (double) Calendar.getInstance().get(Calendar.MONTH);
			case "year": yield (double) Calendar.getInstance().get(Calendar.YEAR);
			
			
			
			/* Food and health */
			case "saturation": yield (double) p.method_7344().method_7589();
			case "hunger": yield (double) p.method_7344().method_7586();
			case "health", "hp": yield (double) p.method_6032();
			case "maxhealth", "maxhp": yield (double) p.method_6063();
			
			
			
			/* Other Player related information */
			case "selectedslot": yield (double) p.method_31548().field_7545;
			case "xplevel": yield (double) p.field_7520;
			case "xp": yield (double) p.field_7495;
			case "armor": yield (double) p.method_6096();

			case "playerspeed": {
				var ent = p.method_5854() == null ? p : p.method_5854();

			    double speed = (Math.sqrt(Math.pow(ent.method_23317() - ent.field_6038, 2) +
			    		Math.pow(ent.method_23318() - ent.field_5971 , 2) + Math.pow(ent.method_23321() - ent.field_5989 , 2)) * 20);
			    yield speed;
			}
			case "horizontal_playerspeed": {
				var ent = p.method_5854() == null ? p : p.method_5854();

			    double speed = (Math.sqrt(Math.pow(ent.method_23317() - ent.field_6038, 2) + Math.pow(ent.method_23321() - ent.field_5989 , 2)) * 20);
			    yield speed;
			}
			
			
			
			/* Player position */
			case "dxpos","dx": yield p.method_23317();
			case "dypos","dy": yield p.method_23318();
			case "dzpos","dz": yield p.method_23321();
			case "xpos","x": yield (double) p.method_31477();
			case "ypos","y": yield (double) p.method_31478();
			case "zpos","z": yield (double) p.method_31479();
			
			
			
			/* Chunk information */
			case "subchunkx": yield (double) (p.method_31477() & 0xF);
			case "subchunky": yield (double) (p.method_31478() & 0xF);
			case "subchunkz": yield (double) (p.method_31479() & 0xF);
			case "chunkx": yield (double) p.method_31476().field_9181;
			case "chunkz": yield (double) p.method_31476().field_9180;
			
			
			
			/* Player roation*/
			case "dpitch": yield (double) p.method_36455();
			case "dyaw": yield p.method_5791() % 360d;
			case "pitch": yield (double) (int) p.method_36455();
			case "yaw": yield (double) (int) p.method_5791() % 360;
			
			

			/* World Rendering */
			case "entites", "entities": yield (double) ((WorldRendererAccess)ins.field_1769).getVisibleEntityCount();
			case "particles": yield (double) ((ParticleManagerAccessor)ins.field_1713)
				.getParticles().values().stream().mapToInt(Queue::size).sum();
			case "chunks": yield (double) ins.field_1769.method_3246();
			
			
			
			/* World */
			case "light": yield (double) ins.field_1687.method_22339(p.method_24515());
			case "blocklight", "block_light": yield (double) ins.field_1687.method_8314(class_1944.field_9282,p.method_24515());
			case "skylight", "sky_light": yield (double) ins.field_1687.method_8314(class_1944.field_9284,p.method_24515());
			case "worldtime", "world_time": yield (double) ins.field_1687.method_8532();
			case "daytime", "day_time": yield ins.field_1687.method_8532()/24000d;
			
			
			
			/* Hudder rendering */
			case "width": yield (double) ins.method_22683().method_4486();
			case "height": yield (double) ins.method_22683().method_4502();
			case "guiscale": yield ins.method_22683().method_4495();

			case "scale": yield (double) config.scale;
			case "color": yield (double) config.color;
			case "yoffset": yield (double) config.yoffset;
			case "xoffset": yield (double) config.xoffset;
			case "lineheight": yield (double) config.lineHeight;
			case "methodbuffer": yield (double) config.methodBuffer;
			case "backgroundcolor": yield (double) config.backgroundcolor;
			
			
			
			/* Item Durabilities V3.0.0 */
			case "held_item_durability","helmet_durability","chestplate_durability","leggings_durability",
			"boots_durability","offhand_durability": {
				class_1799 stack = getStack(key, p.method_31548());
				yield (double) stack.method_7936() - stack.method_7919();
			}
			case"held_item_max_durability","helmet_max_durability","chestplate_max_durability","leggings_max_durability",
			"boots_max_durability","offhand_max_durability":yield (double)getStack(key, p.method_31548()).method_7936();
			
			
			
			case "rebeccapurple": yield (double) 0xFF663399;
			
			default: yield null;
		};
	}
	public static float getTPS(class_310 client) {
        class_1132 server = client.method_1576();
        return server == null ? -1f : server.method_54833().method_54748();
	}
	public static class_1799 getStack(String type, class_1661 inv) {
		//I took some short cuts for a tiny performance increase. Probably not even calculatable.
		if (type.startsWith("held")) return inv.method_5438(inv.field_7545);//held_item
		if (type.startsWith("helm")) return inv.method_7372(3);//helmet
		if (type.startsWith("c")) return inv.method_7372(2);//chestplate
		if (type.startsWith("l")) return inv.method_7372(1);//leggings
		if (type.startsWith("b")) return inv.method_7372(0);//boots
		if (type.startsWith("o")) return inv.field_7544.get(0);//offhand
		throw new IllegalArgumentException("Unexpected value: " + type);
	}
}
