package dev.ngspace.ngsmcconfig.options;

import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_4185;
import dev.ngspace.ngsmcconfig.api.AbstractNGSMCConfigOptionBuilder;
import dev.ngspace.ngsmcconfig.gui.NGSMCConfigEntry;

public class BooleanNGSMCConfigOption extends AbstractNGSMCConfigOption<Boolean> {
	
	protected BooleanNGSMCConfigOption(Boolean defaultValue, Boolean value, class_2561 text,
			Consumer<Boolean> saveOperation, Function<Boolean, class_2561> validator) {
		super(defaultValue, value, text, saveOperation, validator);
	}

	Function<Boolean, class_2561> yesno = b->class_2561.method_43471("ngsmcconfig."+b);
	class_4185 widget;

	@Override
	public NGSMCConfigEntry buildEntry() {
        widget = class_4185.method_46430(class_2561.method_43470(""), button->{
			edited = true;
        	value = !value;
            button.method_25355(yesno.apply(value));
        }).method_46437(100, 20).method_46431();
        widget.method_25355(yesno.apply(value));
		return new NGSMCConfigEntry(widget, text, this);
	}
	
	public static AbstractNGSMCConfigOptionBuilder<Boolean> builder(boolean value, class_2561 name) {
		return new AbstractNGSMCConfigOptionBuilder<Boolean>(value, name) {
			@Override public AbstractNGSMCConfigOption<Boolean> build() {
				return new BooleanNGSMCConfigOption(defaultValue, value, name, saveOperation, validator);
			}
		};
	}

	@Override
	public void reset() {
		edited = true;
    	value = defaultValue;
    	if (widget!=null)
    		widget.method_25355(yesno.apply(value));
	}
}
