package dev.ngspace.ngsmcconfig.options;

import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_2561;
import dev.ngspace.ngsmcconfig.api.AbstractNGSMCConfigOptionBuilder;

public class DoubleNGSMCConfigOption extends AbstractTextFieldNGSMCConfigOption<Double> {

	protected boolean validnum = true;
	protected String invalidnum;
	
	protected DoubleNGSMCConfigOption(double defaultValue, double value, class_2561 text, Consumer<Double> saveOperation,
			Function<Double, class_2561> validator) {
		super(defaultValue, value, text, saveOperation, validator);
		this.validator = val->{
			if (!validnum)
				return class_2561.method_43470("Invalid number: \"" + invalidnum + "\"");
			return validator==null?null:validator.apply(val);
		};
		textfilter = val -> {
			boolean passfilter = val.chars().allMatch(c->Character.isDigit(c)||c=='-'||c=='.');
			if (passfilter) {
				try {
					this.value = Double.parseDouble(val);
					validnum = true;
				} catch (NumberFormatException e) {
					validnum = false;
					invalidnum = val;
				}
			}
			return passfilter;
		};
	}
	
	public static AbstractNGSMCConfigOptionBuilder<Double> builder(double value, class_2561 name) {
		return new AbstractNGSMCConfigOptionBuilder<Double>(value, name) {
			@Override public AbstractNGSMCConfigOption<Double> build() {
				return new DoubleNGSMCConfigOption(defaultValue, value, name, saveOperation, validator);
			}
		};
	}
}