package dev.ngspace.ngsmcconfig.options;

import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import dev.ngspace.ngsmcconfig.api.AbstractNGSMCConfigOptionBuilder;
import dev.ngspace.ngsmcconfig.gui.NGSMCConfigEntry;

public class HexNGSMCConfigOption extends AbstractNGSMCConfigOption<Integer> {

	protected boolean validnum = true;
	protected String invalidnum;
	protected class_342 widget;
	
	protected HexNGSMCConfigOption(Integer defaultValue, Integer value, class_2561 text, Consumer<Integer> saveOperation,
			Function<Integer, class_2561> validator) {
		super(defaultValue, value, text, saveOperation, validator);
		
		this.validator = val->{
			if (!validnum)
				return class_2561.method_43470("Invalid hex value: \"" + invalidnum + "\"");
			return validator==null?null:validator.apply(val);
		};
	}

	@Override
	public NGSMCConfigEntry buildEntry() {
		widget = new class_342(class_310.method_1551().field_1772, 0, 0, 100, 20, class_2561.method_43470("")) {
			@Override
			public void method_48579(class_332 guiGraphics, int i, int j, float f) {
				guiGraphics.method_44379(method_46426(), method_46427(), method_55442()-20, method_55443());
				super.method_48579(guiGraphics, i, j, f);
				guiGraphics.method_44380();
				guiGraphics.method_25294(method_55442()-20, method_55443()-20, method_55442(), method_55443(), value);
			}
		};
		widget.method_1880(10);
		widget.method_1852("#"+String.format("%1$08X",value));
		widget.method_1890(val->{
			edited = true;
			try {
				this.value = Integer.parseUnsignedInt(val.substring(val.charAt(0)=='#' ? 1 : 2), 16);
				validnum = true;
			} catch (NumberFormatException | StringIndexOutOfBoundsException e) {
				validnum = false;
				invalidnum = val;
			}
			return true;
		});
		return new NGSMCConfigEntry(widget, text, this);
	}
	
	public static AbstractNGSMCConfigOptionBuilder<Integer> builder(int value, class_2561 name) {
		return new AbstractNGSMCConfigOptionBuilder<Integer>(value, name) {
			@Override public AbstractNGSMCConfigOption<Integer> build() {
				return new HexNGSMCConfigOption(defaultValue, value, name, saveOperation, validator);
			}
		};
	}

	@Override
	public void reset() {
		edited = true;
		value = defaultValue;
    	if (widget!=null)
    		widget.method_1852("#"+String.format("%1$08X",value));
	}
}
