package io.github.ngspace.hudder.main.config;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import dev.ngspace.ngsmcconfig.api.NGSMCConfigBuilder;
import dev.ngspace.ngsmcconfig.api.NGSMCConfigCategory;
import dev.ngspace.ngsmcconfig.options.BooleanNGSMCConfigOption;
import dev.ngspace.ngsmcconfig.options.DoubleNGSMCConfigOption;
import dev.ngspace.ngsmcconfig.options.HexNGSMCConfigOption;
import dev.ngspace.ngsmcconfig.options.IntNGSMCConfigOption;
import dev.ngspace.ngsmcconfig.options.StringNGSMCConfigOption;
import io.github.ngspace.hudder.Hudder;
import io.github.ngspace.hudder.compilers.utils.Compilers;
import io.github.ngspace.hudder.utils.HudFileUtils;

public class HudderNGSMCConfigMenu { private HudderNGSMCConfigMenu() {}
	
	protected static class_310 mc = class_310.method_1551();

	public static class_437 createMenu(class_437 parent) {
		HudderConfig config = Hudder.config;
		
		var builder = new NGSMCConfigBuilder(parent);
		builder.setWriteOperation(() -> {
			try {
				config.save();
			} catch (IOException e) {
				e.printStackTrace();
			}
		});
		builder.setWikiUri(URI.create("https://ngspace.dev/hudder"));
		builder.setConfigFile(new File(HudFileUtils.FOLDER));
		
		
		
		// General
		NGSMCConfigCategory general = builder.createCategory(class_2561.method_43471("hudder.general"));
		NGSMCConfigCategory text = builder.createCategory(class_2561.method_43471("hudder.text"));
		NGSMCConfigCategory advanced = builder.createCategory(class_2561.method_43471("hudder.advanced"));
//		NGSMCConfigCategory variables = builder.createCategory(Component.translatable("hudder.global_variables"));
		
		
		
		/* General */
		general.addOption(BooleanNGSMCConfigOption.builder(config.enabled, class_2561.method_43471("hudder.general.enabled"))
				.setHoverComponent(class_2561.method_43471("hudder.general.enabled.tooltip"))
				.setDefaultValue(true)
				.setSaveOperation(b->config.enabled=b)
				.build());
		general.addOption(StringNGSMCConfigOption.builder(config.mainfile, class_2561.method_43471("hudder.general.mainfile"))
				.setHoverComponent(class_2561.method_43471("hudder.general.mainfile.tooltip"))
				.setDefaultValue("hud")
				.setSaveOperation(s->config.mainfile=s)
				.setValidator(val->{
					if (!HudFileUtils.exists(val))
						return class_2561.method_43471("hudder.general.mainfile.error");
					return null;
				})
				.build());
		general.addOption(DoubleNGSMCConfigOption.builder(config.scale, class_2561.method_43471("hudder.general.scale"))
				.setHoverComponent(class_2561.method_43471("hudder.general.scale.tooltip"))
				.setSaveOperation(b->config.scale=b.floatValue())
				.setDefaultValue(1d)
				.build());
		
		
		
		/* Text */
		text.addOption(HexNGSMCConfigOption.builder(config.color, class_2561.method_43471("hudder.text.color"))
				.setHoverComponent(class_2561.method_43471("hudder.text.color.tooltip"))
				.setDefaultValue(0xFFd6d6d6)
				.setSaveOperation(b->config.color=b)
				.build());
		text.addOption(HexNGSMCConfigOption.builder(config.backgroundcolor,
				class_2561.method_43471("hudder.text.backgroundcolor"))
				.setHoverComponent(class_2561.method_43471("hudder.text.backgroundcolor.tooltip"))
				.setDefaultValue(0x86353535)
				.setSaveOperation(b->config.backgroundcolor=b)
				.build());
		text.addOption(BooleanNGSMCConfigOption.builder(config.background, class_2561.method_43471("hudder.text.background"))
				.setHoverComponent(class_2561.method_43471("hudder.text.background.tooltip"))
				.setSaveOperation(b->config.background=b)
				.setDefaultValue(true)
				.build());
		text.addOption(BooleanNGSMCConfigOption.builder(config.shadow, class_2561.method_43471("hudder.text.shadow"))
				.setHoverComponent(class_2561.method_43471("hudder.text.shadow.tooltip"))
				.setSaveOperation(b->config.shadow=b)
				.setDefaultValue(true)
				.build());
		text.addOption(IntNGSMCConfigOption.builder(config.yoffset, class_2561.method_43471("hudder.text.yoffset"))
				.setHoverComponent(class_2561.method_43471("hudder.text.yoffset.tooltip"))
				.setSaveOperation(b->config.yoffset=b)
				.setDefaultValue(1)
				.build());
		text.addOption(IntNGSMCConfigOption.builder(config.xoffset, class_2561.method_43471("hudder.text.xoffset"))
				.setHoverComponent(class_2561.method_43471("hudder.text.xoffset.tooltip"))
				.setSaveOperation(b->config.xoffset=b)
				.setDefaultValue(1)
				.build());
		text.addOption(IntNGSMCConfigOption.builder(config.lineHeight, class_2561.method_43471("hudder.text.height"))
				.setHoverComponent(class_2561.method_43471("hudder.text.height.tooltip"))
				.setSaveOperation(b->config.lineHeight=b)
				.setDefaultValue(10)
				.build());
		
		
		
		/* Advanced */
		advanced.addOption(IntNGSMCConfigOption.builder(config.methodBuffer, class_2561.method_43471("hudder.advanced.method"))
				.setHoverComponent(class_2561.method_43471("hudder.advanced.method.tooltip"))
				.setSaveOperation(b->config.methodBuffer=b)
				.setDefaultValue(2)
				.build());
		advanced.addOption(BooleanNGSMCConfigOption.builder(config.showInF3, class_2561.method_43471("hudder.advanced.f3"))
				.setHoverComponent(class_2561.method_43471("hudder.advanced.f3.tooltip"))
				.setSaveOperation(b->config.showInF3=b)
				.setDefaultValue(false)
				.build());
		advanced.addOption(StringNGSMCConfigOption.builder(config.compilertype,
					class_2561.method_43471("hudder.advanced.compilertype"))
	    		.setHoverComponent(class_2561.method_43471("hudder.advanced.compilertype.tooltip"))
	    		.setDefaultValue("hudder")
	    		.setSaveOperation(b->config.setCompiler(b.toLowerCase()))
	    		.setValidator(e->!Compilers.has(e.toLowerCase())?class_2561.method_43471("hudder.advanced.compilertype.error"):null)
	    		.build());
		advanced.addOption(BooleanNGSMCConfigOption.builder(config.unsafeoperations, class_2561.method_43471("hudder.advanced.unsafeoperations"))
				.setHoverComponent(class_2561.method_43471("hudder.advanced.unsafeoperations.tooltip"))
				.setSaveOperation(b->config.unsafeoperations=b)
				.setDefaultValue(false)
				.build());
		advanced.addOption(BooleanNGSMCConfigOption.builder(config.removegui, class_2561.method_43471("hudder.advanced.removehotbar"))
				.setHoverComponent(class_2561.method_43471("hudder.advanced.removehotbar.tooltip"))
				.setSaveOperation(b->config.removegui=b)
				.setDefaultValue(false)
				.build());
		advanced.addOption(BooleanNGSMCConfigOption.builder(config.limitrate, class_2561.method_43471("hudder.advanced.limitrate"))
				.setHoverComponent(class_2561.method_43471("hudder.advanced.limitrate.tooltip"))
				.setSaveOperation(b->config.limitrate=b)
				.setDefaultValue(true)
				.build());
		
		
		

//		variables.addOption(BooleanNGSMCConfigOption.builder(Component.translatable("hudder.global_variables"),
//						config.globalVariablesEnabled)
//				.setHoverComponent(Component.translatable("hudder.global_variables.enabled.tooltip"))
//				.setSaveOperation(b->config.globalVariablesEnabled=b)
//				.setDefaultValue(true)
//				.build());
		
		return builder.build();
	}
	
}
