package io.github.ngspace.hudder.uielements;

import org.apache.commons.lang3.tuple.Pair;

import io.github.ngspace.hudder.main.HudderRenderer;
import io.github.ngspace.hudder.mixin.InGameHudAccessor;
import net.minecraft.class_11223;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_9779;

/**
 * This element is a merging of all builtin GUI elements (Status bars) 
 * with the goal of allowing the creation of a custom
 * game hud without forcing the user to reimplement every single UI Element themselves
 */
public class GameHudElement extends AUIElement {
	
	protected static class_310 mc = class_310.method_1551();
	public enum GuiType {
		STATUS_BARS,
		EXP_AND_MOUNT_BAR,
		HOTBAR,
		ITEM_TOOLTIP;
	}
	
	public final int x;
	public final int y;
	public final GuiType type;
	
	public GameHudElement(int x, int y, GuiType type) {
		this.x = x;
		this.y = y;
		this.type = type;
	}

	@Override public void renderElement(class_332 context, HudderRenderer renderer, class_9779 delta) {
		try {
			InGameHudAccessor acchud = (InGameHudAccessor) (mc.field_1705);
			float scaledWidth = context.method_51421();
	        float scaledHeight = context.method_51443();
	        var matrixStack = context.method_51448();
	        matrixStack.pushMatrix();
	        switch (type) {
				case STATUS_BARS:
			        if (mc.field_1761.method_2908()) {
				        matrixStack.translate(x-scaledWidth/2, y-scaledHeight + 39);
				        acchud.callRenderPlayerHealth(context);
				        acchud.callRenderVehicleHealth(context);
			        }
			        break;
				case EXP_AND_MOUNT_BAR:
					matrixStack.translate(x-scaledWidth/2, y-scaledHeight + 39);
					class_329.class_11220 contextualInfo = acchud.callNextContextualInfoState();
					var contextualInfoBar = acchud.contextualInfoBar();
					var contextualInfoBarRenderers = acchud.contextualInfoBarRenderers();
					if (contextualInfo != contextualInfoBar.getKey()) {
						contextualInfoBar = Pair.of(contextualInfo, contextualInfoBarRenderers.get(contextualInfo).get());
					}

					contextualInfoBar.getValue().method_70865(context, delta);
					if (mc.field_1761.method_2913() && mc.field_1724.field_7520 > 0) {
						class_11223.method_70866(context, mc.field_1772, mc.field_1724.field_7520);
					}

					contextualInfoBar.getValue().method_70868(context, delta);
					break;
				case HOTBAR:
			        matrixStack.translate(x-scaledWidth/2, y-scaledHeight);
			        acchud.callRenderHotbarAndDecorations(context, delta);
					break;
				case ITEM_TOOLTIP:
					int tooltipy = 44;
					if (mc.field_1761.method_2908()) tooltipy += 14;
			        matrixStack.translate(x-scaledWidth/2, tooltipy-scaledHeight+y);
			        acchud.callRenderSelectedItemName(context);
					break;
				default:
					break;
			}
	        matrixStack.popMatrix();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

}
