/*
 * Decompiled with CFR 0.152.
 */
package io.github.ngspace.hudder.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1044;
import net.minecraft.class_2960;
import net.minecraft.class_310;

public class CachedReader {
    protected static class_310 mc = class_310.method_1551();
    public Reader reader = new FilesRABReader();
    HashMap<String, byte[]> savedFiles = new HashMap();
    HashMap<String, String> savedFilesStrings = new HashMap();
    HashMap<class_2960, class_1043> savedImages = new HashMap();

    public byte[] getCachedFile(String file) {
        return this.savedFiles.get(file);
    }

    public String getCachedFileAsString(String file) {
        String contents = this.savedFilesStrings.get(file);
        if (contents == null) {
            contents = new String(this.getCachedFile(file));
            this.savedFilesStrings.put(file, contents);
            return contents;
        }
        return contents;
    }

    public boolean loadFileToCache(File file) throws IOException {
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            if (!file.createNewFile()) {
                return false;
            }
        }
        this.savedFiles.put(file.getAbsolutePath(), this.reader.readFile(file));
        return true;
    }

    public boolean loadImageToCache(InputStream inputStream, class_2960 id) throws IOException {
        if (this.savedImages.containsKey(id)) {
            mc.method_1531().method_4615(id);
            this.savedImages.get(id).close();
            this.savedImages.remove(id);
        }
        class_1011 img = class_1011.method_4309((InputStream)inputStream);
        class_1043 tex = new class_1043(() -> ((class_2960)id).method_12832(), img);
        mc.method_1531().method_4616(id, (class_1044)tex);
        this.savedImages.put(id, tex);
        return true;
    }

    public void clearCache() {
        for (Map.Entry<class_2960, class_1043> v : this.savedImages.entrySet()) {
            mc.method_1531().method_4615(v.getKey());
            v.getValue().close();
        }
        this.savedImages.clear();
        this.savedFiles.clear();
        this.savedFilesStrings.clear();
    }

    public static class FilesRABReader
    implements Reader {
        @Override
        public byte[] readFile(File file) throws IOException {
            return Files.readAllBytes(file.toPath());
        }
    }

    public static interface Reader {
        public byte[] readFile(File var1) throws IOException;
    }

    @Deprecated(since="8.6.0", forRemoval=true)
    public static class ScannerReader
    implements Reader {
        @Override
        public byte[] readFile(File file) throws IOException {
            Scanner reader = new Scanner(file);
            Object res = "";
            while (reader.hasNextLine()) {
                res = (String)res + reader.nextLine();
                res = (String)res + "\n";
            }
            reader.close();
            if (((String)res).isEmpty()) {
                return ((String)res).getBytes();
            }
            return ((String)res).substring(0, ((String)res).length() - 1).getBytes();
        }
    }
}

