/*
 * Decompiled with CFR 0.152.
 */
package io.github.ngspace.hudder.v2runtime.functions;

import io.github.ngspace.hudder.compilers.utils.CompileException;
import io.github.ngspace.hudder.v2runtime.V2Runtime;
import io.github.ngspace.hudder.v2runtime.functions.IV2Function;
import io.github.ngspace.hudder.v2runtime.values.AV2Value;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;

public class DoubleV2Function
implements IV2Function {
    @Override
    public Object execute(V2Runtime runtime, String functionName, AV2Value[] args, int line, int charpos) throws CompileException {
        Object value = args[0].get();
        if (value == null) {
            throw new CompileException("Value of variable is null!", line, charpos);
        }
        Object object = value;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Number.class, String.class, Boolean.class, Character.class}, (Object)object2, n)) {
            case 0: {
                Number num = (Number)object2;
                return num.intValue();
            }
            case 1: {
                String str = (String)object2;
                return Double.parseDouble(str);
            }
            case 2: {
                Boolean bool = (Boolean)object2;
                return Boolean.TRUE.equals(bool) ? 1.0 : 0.0;
            }
            case 3: {
                Character c = (Character)object2;
                return (int)c.charValue();
            }
        }
        return Double.parseDouble(value.toString());
    }
}

