/*
 * Decompiled with CFR 0.152.
 */
package io.github.ngspace.hudder.compilers.abstractions;

import io.github.ngspace.hudder.Hudder;
import io.github.ngspace.hudder.compilers.abstractions.ATextCompiler;
import io.github.ngspace.hudder.compilers.utils.CompileException;
import io.github.ngspace.hudder.data_management.BooleanData;
import io.github.ngspace.hudder.data_management.NumberData;
import io.github.ngspace.hudder.data_management.ObjectDataAPI;
import io.github.ngspace.hudder.data_management.StringData;

public abstract class AVarTextCompiler
extends ATextCompiler {
    @Override
    public Object getVariable(String key) throws CompileException {
        Object obj = this.getSystemVariable(key);
        if (obj == null && (obj = this.getDynamicVariable(key)) != null) {
            return obj;
        }
        if (obj != null) {
            return obj;
        }
        return key;
    }

    public boolean isSystemVariable(String key) {
        return this.getSystemVariable(key) != null || "null".equals(key);
    }

    public Object getSystemVariable(String key) {
        Object obj = NumberData.getNumber(key);
        if (obj != null) {
            return obj;
        }
        obj = BooleanData.getBoolean(key);
        if (obj != null) {
            return obj;
        }
        obj = StringData.getString(key);
        if (obj != null) {
            return obj;
        }
        obj = ObjectDataAPI.getObject(key);
        if (obj != null) {
            return obj;
        }
        obj = Hudder.config.globalVariables.get(key);
        if (obj != null) {
            return obj;
        }
        return null;
    }

    public Object getDynamicVariable(String key) {
        Object obj = this.get(key);
        if (obj != null) {
            return obj;
        }
        return key;
    }
}

