/*
 * Decompiled with CFR 0.152.
 */
package io.github.ngspace.hudder.main;

import io.github.ngspace.hudder.Hudder;
import io.github.ngspace.hudder.main.config.HudderNGSMCConfigMenu;
import io.github.ngspace.hudder.utils.HudFileUtils;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public class HudderTickEvent
implements ClientTickEvents.StartTick {
    private WatchService watcherService;

    public HudderTickEvent() {
        try {
            this.watcherService = FileSystems.getDefault().newWatchService();
            Files.walkFileTree(Path.of(HudFileUtils.FOLDER, new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    dir.register(HudderTickEvent.this.watcherService, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void onStartTick(class_310 client) {
        block9: {
            while (Hudder.configkeybind.method_1436()) {
                class_310.method_1551().method_1507(HudderNGSMCConfigMenu.createMenu(class_310.method_1551().field_1755));
            }
            if (!Hudder.config.enabled) {
                return;
            }
            try {
                if (this.watcherService == null) {
                    return;
                }
                WatchKey wk = this.watcherService.poll();
                if (wk == null) break block9;
                for (WatchEvent<?> event : wk.pollEvents()) {
                    Path changed = (Path)event.context();
                    try {
                        Hudder.log(String.valueOf(changed.getFileName()) + " has changed! Refreshing files!");
                        HudFileUtils.reloadResources();
                        Hudder.showToast((class_2561)class_2561.method_43470((String)"Refreshed files!").method_27692(class_124.field_1067), (class_2561)class_2561.method_43470((String)("\u00a7a" + String.valueOf(changed.getFileName()) + " changed.")));
                    }
                    catch (IOException e) {
                        Hudder.showToast((class_2561)class_2561.method_43470((String)"\\u00A74Error refreshing files!").method_27692(class_124.field_1067), (class_2561)class_2561.method_43470((String)e.getMessage()));
                        e.printStackTrace();
                    }
                    if (!changed.toString().equals("hud.json")) continue;
                    Hudder.config.readConfig();
                    Hudder.showToast((class_2561)class_2561.method_43470((String)"Refreshed Config file!").method_27692(class_124.field_1067), (class_2561)class_2561.method_43470((String)"\u00a7aLoaded File"));
                }
                if (!wk.reset()) {
                    this.watcherService = null;
                    Hudder.error("Unable to watch for changes in config folder!");
                    Hudder.showToast((class_2561)class_2561.method_43470((String)"\u00a74Failed to reload files!").method_27692(class_124.field_1067));
                }
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
    }
}

