package io.github.ngspace.hudder.mixin;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import static io.github.ngspace.hudder.Hudder.config;
import io.github.ngspace.hudder.data_management.Advanced;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_310;
import net.minecraft.class_340;

@Environment(EnvType.CLIENT)
@Mixin(class_310.class)
public abstract class MinecraftClientInjections {
	
    @Shadow private double gpuUtilization;
    @Inject(method = "runTick", at = @At(value = "INVOKE",
    		target = "Ljava/lang/String;format(Ljava/util/Locale;Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;"))
    public void getGpuUsage(boolean tick, CallbackInfo ci) {
    	Advanced.gpuUsage = gpuUtilization > 100 ? 100 : gpuUtilization;
    }
    
    @Redirect(method = "runTick", at = @At(value = "INVOKE",
    		target = "Lnet/minecraft/client/gui/components/DebugScreenOverlay;showDebugScreen()Z"))
    public boolean shouldGetGpuUsage(class_340 hud) {
    	return hud.method_53536()||config.enabled;
    }
}
  