/*
 * Decompiled with CFR 0.152.
 */
package io.github.ngspace.hudder.compilers.utils;

import io.github.ngspace.hudder.Hudder;
import io.github.ngspace.hudder.compilers.utils.CompileException;
import io.github.ngspace.hudder.compilers.utils.HudInformation;
import io.github.ngspace.hudder.compilers.utils.functionandconsumerapi.IUIElementManager;
import io.github.ngspace.hudder.uielements.AUIElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CompileState
implements IUIElementManager {
    public static final String TOPLEFT = "topleft";
    public static final String BOTTOMLEFT = "bottomleft";
    public static final String TOPRIGHT = "topright";
    public static final String BOTTOMRIGHT = "bottomright";
    public static final String MUTE = "mute";
    public String pos;
    public String TLText = "";
    public String BLText = "";
    public String TRText = "";
    public String BRText = "";
    public float TLScale = 1.0f;
    public float BLScale = 1.0f;
    public float TRScale = 1.0f;
    public float BRScale = 1.0f;
    public boolean hasBroken = false;
    public List<AUIElement> elements = new ArrayList<AUIElement>();
    public Object returnValue;
    public boolean hasReturned;

    public CompileState(String string) {
        this.setTextLocation(string, Hudder.config.scale);
    }

    public void addString(String txt, boolean cleanup) throws CompileException {
        this.addString(txt, this.pos, cleanup);
    }

    protected void addString(String txt, String pos, boolean cleanup) throws CompileException {
        String text = txt;
        if (cleanup) {
            int buffer = Hudder.config.methodBuffer;
            if (buffer < 10) {
                for (int i = 0; i < buffer; ++i) {
                    try {
                        if (text.startsWith("\r\n")) {
                            text = text.substring(2);
                        }
                        if (!text.endsWith("\r\n")) continue;
                        text = text.substring(0, text.length() - 2);
                        continue;
                    }
                    catch (StringIndexOutOfBoundsException e) {
                        throw new CompileException("Empty section \"" + pos + "\"");
                    }
                }
            } else {
                text = text.trim();
            }
        }
        switch (pos) {
            case "topleft": {
                this.TLText = this.TLText + text;
                break;
            }
            case "bottomleft": {
                this.BLText = this.BLText + text;
                break;
            }
            case "topright": {
                this.TRText = this.TRText + text;
                break;
            }
            case "bottomright": {
                this.BRText = this.BRText + text;
                break;
            }
            case "mute": {
                break;
            }
            default: {
                throw new CompileException("Unidentifiable meta state \"" + pos + "\"");
            }
        }
    }

    public void setTextLocation(String text, float d) {
        switch (this.pos = text.toLowerCase()) {
            case "topleft": {
                this.TLScale = d;
                break;
            }
            case "bottomleft": {
                this.BLScale = d;
                break;
            }
            case "topright": {
                this.TRScale = d;
                break;
            }
            case "bottomright": {
                this.BRScale = d;
                break;
            }
        }
    }

    public HudInformation toResult() {
        return new HudInformation(this.TLText, this.TLScale, this.BLText, this.BLScale, this.TRText, this.TRScale, this.BRText, this.BRScale, this.elements.toArray(new AUIElement[this.elements.size()]));
    }

    public void combineWithResult(HudInformation compile, boolean combineText) throws CompileException {
        if (combineText) {
            this.addString(compile.TopLeftText, TOPLEFT, false);
            this.TLScale = compile.TLScale;
            this.addString(compile.BottomLeftText, BOTTOMLEFT, false);
            this.BLScale = compile.BLScale;
            this.addString(compile.TopRightText, TOPRIGHT, false);
            this.TRScale = compile.TRScale;
            this.addString(compile.BottomRightText, BOTTOMRIGHT, false);
            this.BRScale = compile.BRScale;
        }
        Collections.addAll(this.elements, compile.elements);
    }

    @Override
    public void addUIElement(AUIElement UIElement) {
        this.elements.add(UIElement);
    }

    @Override
    public AUIElement[] toUIElementArray() {
        return this.elements.toArray(new AUIElement[this.elements.size()]);
    }

    public void setReturnValue(Object value) {
        this.hasReturned = true;
        this.returnValue = value;
    }
}

