/*
 * Decompiled with CFR 0.152.
 */
package io.github.ngspace.hudder.compilers.utils;

import io.github.ngspace.hudder.Hudder;
import io.github.ngspace.hudder.compilers.abstractions.ATextCompiler;
import java.util.HashMap;
import java.util.Map;

public class Compilers {
    private static Map<String, String> Comps = new HashMap<String, String>();
    private static final Map<String, ATextCompiler> loadedcomps = new HashMap<String, ATextCompiler>();
    private static final String EMPTY_COMPILER = "io.github.ngspace.hudder.compilers.EmptyCompiler";
    private static final String DEFAULT_COMPILER = "io.github.ngspace.hudder.compilers.HudderV2Compiler";
    private static final String JAVASCRIPT_COMPILER = "io.github.ngspace.hudder.compilers.JavaScriptCompiler";

    private Compilers() {
    }

    public static ATextCompiler getCompilerFromName(String name) throws ReflectiveOperationException, IllegalArgumentException, SecurityException {
        String comp = name.toLowerCase();
        if (loadedcomps.containsKey(comp)) {
            return loadedcomps.get(comp);
        }
        if (Comps.containsKey(comp)) {
            loadedcomps.put(comp, (ATextCompiler)Class.forName(Comps.get(comp)).getConstructor(new Class[0]).newInstance(new Object[0]));
            return loadedcomps.get(comp);
        }
        return Compilers.getCompilerFromName("default");
    }

    private static void putCompiler(String name, String classname) {
        Comps.put(name, classname);
    }

    public static void registerCompiler(String name, String classname) {
        Comps.put(name.toLowerCase(), classname);
        Hudder.config.readConfig();
    }

    @Deprecated(since="4.0.0", forRemoval=true)
    public static void registerLoadedCompiler(String name, ATextCompiler compiler) {
        loadedcomps.put(name.toLowerCase(), compiler);
        Hudder.config.readConfig();
    }

    public static boolean has(String name) {
        return loadedcomps.get(name.toLowerCase()) != null || Comps.get(name.toLowerCase()) != null;
    }

    static {
        Compilers.putCompiler("defaultcompiler", DEFAULT_COMPILER);
        Compilers.putCompiler("default compiler", DEFAULT_COMPILER);
        Compilers.putCompiler("default", DEFAULT_COMPILER);
        Compilers.putCompiler("hudder", DEFAULT_COMPILER);
        Compilers.putCompiler("js", JAVASCRIPT_COMPILER);
        Compilers.putCompiler("javascript", JAVASCRIPT_COMPILER);
        Compilers.putCompiler("empty", EMPTY_COMPILER);
        Compilers.putCompiler("none", EMPTY_COMPILER);
        Compilers.putCompiler("null", EMPTY_COMPILER);
        Compilers.putCompiler(null, EMPTY_COMPILER);
    }
}

