/*
 * Decompiled with CFR 0.152.
 */
package io.github.ngspace.hudder.data_management;

import com.sun.management.OperatingSystemMXBean;
import io.github.ngspace.hudder.data_management.LimitedRefreshSpeedData;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_310;
import org.lwjgl.glfw.GLFW;

public class Advanced {
    public static double gpuUsage = 0.0;
    public static float delta = 1.0f;
    public static LimitedRefreshSpeedData<Double> CPU = new LimitedRefreshSpeedData<Double>(((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean())::getProcessCpuLoad, 2000);
    public static String OS = Advanced.getOS();
    private static final List<Integer> fpshistory = new ArrayList<Integer>();
    public static final Map<Integer, Integer> keysheld = new HashMap<Integer, Integer>();
    static HashMap<String, Integer> keys = new HashMap();

    private Advanced() {
    }

    static String getOS() {
        String OS = System.getProperty("os.name", "generic").toLowerCase();
        OS = OS.contains("mac") || OS.contains("darwin") ? "mac" : (OS.contains("nux") ? "linux" : (OS.contains("win") ? "windows" : "other"));
        return OS;
    }

    public static int getFPS(class_310 ins) {
        int fps = ins.method_47599();
        fpshistory.add(fps);
        if (fpshistory.size() > 800) {
            fpshistory.remove(0);
        }
        return fps;
    }

    public static int getMinimumFPS() {
        int max = fpshistory.get(0);
        for (int i : fpshistory) {
            if (i >= max) continue;
            max = i;
        }
        return max;
    }

    public static int getMaximumFPS() {
        int max = 0;
        for (int i : fpshistory) {
            if (i <= max) continue;
            max = i;
        }
        return max;
    }

    public static int getAverageFPS() {
        int sum = 0;
        for (int fps : fpshistory) {
            sum += fps;
        }
        return sum / fpshistory.size();
    }

    public static int isKeyHeld(String key) {
        if (key.length() > 4 && key.length() < 18 && key.startsWith("key_")) {
            int keynum = keys.get(key.substring(4));
            if (keynum == 0) {
                return 0;
            }
            return keysheld.containsKey(keynum) ? 2 : 1;
        }
        return 0;
    }

    static {
        for (Field field : GLFW.class.getFields()) {
            try {
                if (!field.getName().startsWith("GLFW_KEY_") || !field.canAccess(null)) continue;
                keys.put(field.getName().substring(9).toLowerCase(), field.getInt(null));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

