/*
 * Decompiled with CFR 0.152.
 */
package io.github.ngspace.hudder.data_management;

import io.github.ngspace.hudder.Hudder;
import io.github.ngspace.hudder.data_management.Advanced;
import io.github.ngspace.hudder.main.config.HudderConfig;
import io.github.ngspace.hudder.mixin.ParticleManagerAccessor;
import io.github.ngspace.hudder.mixin.WorldRendererAccess;
import java.util.Calendar;
import java.util.Collection;
import net.minecraft.class_1132;
import net.minecraft.class_1944;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_746;

public class NumberData {
    static final double MB = 1048576.0;
    static final Runtime runtime = Runtime.getRuntime();

    private NumberData() {
    }

    public static Double getNumber(String key) {
        class_310 ins = class_310.method_1551();
        class_746 p = ins.field_1724;
        class_4184 c = ins.field_1773.method_19418();
        int fps = Advanced.getFPS(ins);
        HudderConfig config = Hudder.config;
        return switch (key) {
            case "fps" -> fps;
            case "avgfps", "avg_fps" -> Advanced.getAverageFPS();
            case "minfps", "min_fps" -> Advanced.getMinimumFPS();
            case "maxfps", "max_fps" -> Advanced.getMaximumFPS();
            case "ping" -> ins.method_1562().method_2874(p.method_5477().getString()).method_2959();
            case "tps" -> NumberData.getTPS(ins);
            case "gpu_d", "dgpu" -> Advanced.gpuUsage;
            case "gpu" -> (int)Advanced.gpuUsage;
            case "cpu_d" -> Advanced.CPU.get() * 100.0;
            case "cpu" -> (int)(Advanced.CPU.get() * 100.0);
            case "delta" -> Advanced.delta;
            case "totalmemory", "maxmemory", "totalram", "maxram" -> (double)runtime.maxMemory() / 1048576.0;
            case "usedmemory", "usedram" -> (double)(runtime.totalMemory() - runtime.freeMemory()) / 1048576.0;
            case "freememory", "freeram" -> (double)runtime.freeMemory() / 1048576.0;
            case "usedmemory_percentage", "usedram_percentage" -> {
                double usedmem = ((double)runtime.totalMemory() - (double)runtime.freeMemory()) / 1048576.0;
                double totalmem = (double)runtime.maxMemory() / 1048576.0;
                yield (int)(usedmem / totalmem * 100.0);
            }
            case "freememory_percentage", "freeram_percentage" -> (double)runtime.freeMemory() / (double)runtime.maxMemory();
            case "time" -> System.currentTimeMillis();
            case "milliseconds" -> Calendar.getInstance().get(14);
            case "seconds" -> Calendar.getInstance().get(13);
            case "minutes" -> Calendar.getInstance().get(12);
            case "hour" -> Calendar.getInstance().get(11);
            case "day" -> Calendar.getInstance().get(5);
            case "month" -> Calendar.getInstance().get(2);
            case "year" -> Calendar.getInstance().get(1);
            case "saturation" -> p.method_7344().method_7589();
            case "hunger" -> p.method_7344().method_7586();
            case "health", "hp" -> p.method_6032();
            case "maxhealth", "maxhp" -> p.method_6063();
            case "selectedslot" -> p.method_31548().method_67532();
            case "xplevel" -> p.field_7520;
            case "xp" -> p.field_7495;
            case "armor" -> p.method_6096();
            case "falldistance" -> p.field_6017;
            case "playerspeed" -> {
                class_746 ent = p.method_5854() == null ? p : p.method_5854();
                double speed = Math.sqrt(Math.pow(ent.method_23317() - ent.field_6038, 2.0) + Math.pow(ent.method_23318() - ent.field_5971, 2.0) + Math.pow(ent.method_23321() - ent.field_5989, 2.0)) * 20.0;
                yield speed;
            }
            case "horizontal_playerspeed" -> {
                class_746 ent = p.method_5854() == null ? p : p.method_5854();
                double speed = Math.sqrt(Math.pow(ent.method_23317() - ent.field_6038, 2.0) + Math.pow(ent.method_23321() - ent.field_5989, 2.0)) * 20.0;
                yield speed;
            }
            case "dxpos", "dx" -> p.method_23317();
            case "dypos", "dy" -> p.method_23318();
            case "dzpos", "dz" -> p.method_23321();
            case "xpos", "x" -> p.method_31477();
            case "ypos", "y" -> p.method_31478();
            case "zpos", "z" -> p.method_31479();
            case "subchunkx" -> p.method_31477() & 0xF;
            case "subchunky" -> p.method_31478() & 0xF;
            case "subchunkz" -> p.method_31479() & 0xF;
            case "chunkx" -> p.method_31476().field_9181;
            case "chunkz" -> p.method_31476().field_9180;
            case "cam_subchunkx" -> c.method_19328().method_10263() & 0xF;
            case "cam_subchunky" -> c.method_19328().method_10264() & 0xF;
            case "cam_subchunkz" -> c.method_19328().method_10260() & 0xF;
            case "cam_chunkx" -> c.method_19328().method_10263() >> 4;
            case "cam_chunkz" -> c.method_19328().method_10260() >> 4;
            case "dpitch" -> p.method_36455();
            case "pitch" -> (int)p.method_36455();
            case "dyaw" -> {
                float yaw = p.method_5791();
                if (yaw < 0.0f) {
                    yield 360.0 + (double)yaw % 360.0;
                }
                yield (double)yaw % 360.0;
            }
            case "yaw" -> {
                int yaw = (int)p.method_5791();
                if (yaw < 0) {
                    yield 360 + yaw % 360;
                }
                yield (double)yaw % 360.0;
            }
            case "f3_dyaw" -> class_3532.method_15393((float)p.method_5791());
            case "f3_yaw" -> (int)class_3532.method_15393((float)p.method_5791());
            case "cam_dpitch" -> c.method_19329();
            case "cam_pitch" -> (int)c.method_19329();
            case "cam_dyaw" -> {
                float yaw = c.method_19330();
                if (yaw < 0.0f) {
                    yield 360.0 + (double)yaw % 360.0;
                }
                yield (double)yaw % 360.0;
            }
            case "cam_yaw" -> {
                int yaw = (int)c.method_19330();
                if (yaw < 0) {
                    yield 360 + yaw % 360;
                }
                yield (double)yaw % 360.0;
            }
            case "cam_f3_dyaw" -> class_3532.method_15393((float)c.method_19330());
            case "cam_f3_yaw" -> (int)class_3532.method_15393((float)c.method_19330());
            case "entites", "entities" -> ((WorldRendererAccess)ins.field_1769).getVisibleEntityCount();
            case "particles" -> ((ParticleManagerAccessor)ins.field_1713).getParticles().values().stream().mapToInt(Collection::size).sum();
            case "chunks" -> ins.field_1769.method_3246();
            case "light" -> ins.field_1687.method_22339(p.method_24515());
            case "blocklight", "block_light" -> ins.field_1687.method_8314(class_1944.field_9282, p.method_24515());
            case "skylight", "sky_light" -> ins.field_1687.method_8314(class_1944.field_9284, p.method_24515());
            case "cam_light" -> ins.field_1687.method_22339(c.method_19328());
            case "cam_blocklight", "cam_block_light" -> ins.field_1687.method_8314(class_1944.field_9282, c.method_19328());
            case "cam_skylight", "cam_sky_light" -> ins.field_1687.method_8314(class_1944.field_9284, c.method_19328());
            case "worldtime", "world_time" -> ins.field_1687.method_8532();
            case "daytime", "day_time" -> (double)ins.field_1687.method_8532() / 24000.0;
            case "width" -> ins.method_22683().method_4486();
            case "height" -> ins.method_22683().method_4502();
            case "guiscale" -> ins.method_22683().method_4495();
            case "scale" -> config.scale;
            case "color" -> config.color;
            case "yoffset" -> config.yoffset;
            case "xoffset" -> config.xoffset;
            case "lineheight" -> config.lineHeight;
            case "methodbuffer" -> config.methodBuffer;
            case "backgroundcolor" -> config.backgroundcolor;
            case "rebeccapurple" -> -1.0079335E7;
            default -> null;
        };
    }

    public static float getTPS(class_310 client) {
        class_1132 server = client.method_1576();
        return server == null ? -1.0f : server.method_54833().method_54748();
    }
}

