/*
 * Decompiled with CFR 0.152.
 */
package io.github.ngspace.hudder.main;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.vertex.VertexFormat;
import io.github.ngspace.hudder.Hudder;
import io.github.ngspace.hudder.compilers.utils.HudInformation;
import io.github.ngspace.hudder.main.HudCompilationManager;
import io.github.ngspace.hudder.main.config.HudderConfig;
import io.github.ngspace.hudder.uielements.AUIElement;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_10799;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_290;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4668;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_9080;
import net.minecraft.class_9779;
import net.minecraft.class_9851;
import org.joml.Matrix4f;

public class HudderRenderer
implements class_9080.class_9081 {
    private HudCompilationManager compman;
    protected static class_310 mc = class_310.method_1551();
    public static final String NL_REGEX = "\r?\n";
    public static final class_2960 RENDER_LAYER = class_2960.method_60655((String)"hudder", (String)"hudder_render_layer");
    public final class_1921 TriangleColorRenderType;
    public final Function<class_2960, class_1921> TriangleTextureRenderType;

    public HudderRenderer(HudCompilationManager compilationManager) {
        this.compman = compilationManager;
        this.TriangleColorRenderType = class_1921.method_24048((String)"gui", (int)786432, (RenderPipeline)RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{class_10799.field_56863}).withLocation("pipeline/gui").withVertexFormat(class_290.field_1576, VertexFormat.class_5596.field_27380).build(), (class_1921.class_4688)class_1921.class_4688.method_23598().method_23617(false));
        this.TriangleTextureRenderType = class_156.method_34866(id -> class_1921.method_24048((String)"gui_textured", (int)786432, (RenderPipeline)RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{class_10799.field_56864}).withLocation("pipeline/gui_textured").withVertexFormat(class_290.field_1576, VertexFormat.class_5596.field_27380).build(), (class_1921.class_4688)class_1921.class_4688.method_23598().method_34577((class_4668.class_5939)new class_4668.class_4683(id, class_9851.field_52395, false)).method_23617(false)));
    }

    public void renderFail(class_332 context, String FailMessage) {
        List lines = HudderRenderer.mc.field_1772.method_1728(class_5348.method_29430((String)FailMessage), mc.method_22683().method_4486());
        int y = 1;
        for (class_5481 line : lines) {
            context.method_51430(HudderRenderer.mc.field_1772, line, 1, y, 0xFF5555, true);
            y += 9;
        }
    }

    public void drawCompileResult(class_332 context, class_327 renderer, HudInformation text, HudderConfig info, class_9779 delta) {
        int color = info.color;
        int bgcolor = info.backgroundcolor;
        boolean shadow = info.shadow;
        boolean background = info.background;
        String[] lines = text.TopLeftText.split(NL_REGEX);
        int yoff = info.yoffset;
        int xoff = info.xoffset;
        for (String txt : lines) {
            this.renderTextLine(context, txt, xoff, yoff, color, text.TLScale, shadow, background, bgcolor);
            yoff = (int)((float)yoff + (float)info.lineHeight * text.TLScale);
        }
        String[] BL = text.BottomLeftText.split(NL_REGEX);
        yoff = (int)((float)context.method_51443() - (float)(this.countLines(text.BottomLeftText) * info.lineHeight) * text.BLScale - (float)info.yoffset + 1.0f);
        xoff = info.xoffset;
        for (String txt : BL) {
            this.renderTextLine(context, txt, xoff, yoff, color, text.BLScale, shadow, background, bgcolor);
            yoff = (int)((float)yoff + (float)info.lineHeight * text.BLScale);
        }
        String[] TR = text.TopRightText.split(NL_REGEX);
        yoff = info.yoffset;
        for (String txt : TR) {
            xoff = (int)((float)context.method_51421() - (float)renderer.method_1727(txt) * text.TRScale - (float)info.xoffset);
            this.renderTextLine(context, txt, xoff, yoff, color, text.TRScale, shadow, background, bgcolor);
            yoff = (int)((float)yoff + (float)info.lineHeight * text.TRScale);
        }
        String[] BR = text.BottomRightText.split(NL_REGEX);
        yoff = (int)((float)context.method_51443() - (float)(this.countLines(text.BottomRightText) * info.lineHeight) * text.BRScale - (float)info.yoffset + 1.0f);
        for (String txt : BR) {
            xoff = (int)((float)context.method_51421() - (float)renderer.method_1727(txt) * text.BRScale - (float)info.xoffset);
            this.renderTextLine(context, txt, xoff, yoff, color, text.BRScale, shadow, background, bgcolor);
            yoff = (int)((float)yoff + (float)info.lineHeight * text.BRScale);
        }
        for (AUIElement e : text.elements) {
            e.renderElement(context, this, delta);
        }
    }

    public int countLines(String str) {
        int count = 1;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != '\n') continue;
            ++count;
        }
        return count;
    }

    public void renderTextLine(class_332 context, String text, int x, int y, int color, float scale, boolean shadow, boolean background, long backgroundColor) {
        if (scale != 1.0f) {
            class_4587 matrixStack = context.method_51448();
            matrixStack.method_22903();
            matrixStack.method_46416((float)x, (float)y, 0.0f);
            matrixStack.method_22905(scale, scale, scale);
            matrixStack.method_46416((float)(-x), (float)(-y), 0.0f);
            if (background && !"".equals(text)) {
                this.renderBlock(context, (float)x - 1.0f, (float)y - 1.0f, (float)HudderRenderer.mc.field_1772.method_1727(text) + 2.0f, 10.0f, backgroundColor);
            }
            context.method_51433(HudderRenderer.mc.field_1772, text, x, y, color, shadow);
            matrixStack.method_22909();
        } else {
            if (background && !"".equals(text)) {
                this.renderBlock(context, (float)x - 1.0f, (float)y - 1.0f, (float)HudderRenderer.mc.field_1772.method_1727(text) + 2.0f, 10.0f, backgroundColor);
            }
            context.method_51433(HudderRenderer.mc.field_1772, text, x, y, color, shadow);
        }
    }

    public void renderBlock(class_332 context, float x, float y, float width, float height, long argb) {
        int alpha = (int)(argb >> 24 & 0xFFL);
        int red = (int)(argb >> 16 & 0xFFL);
        int green = (int)(argb >> 8 & 0xFFL);
        int blue = (int)(argb & 0xFFL);
        context.method_64039(v -> {
            class_4588 vconsumer = v.getBuffer(class_1921.method_51784());
            Matrix4f matrix = context.method_51448().method_23760().method_23761();
            vconsumer.method_22918(matrix, x, y + height, 0.0f).method_1336(red, green, blue, alpha).method_22921(green, blue);
            vconsumer.method_22918(matrix, x + width, y + height, 0.0f).method_1336(red, green, blue, alpha);
            vconsumer.method_22918(matrix, x + width, y, 0.0f).method_1336(red, green, blue, alpha);
            vconsumer.method_22918(matrix, x, y, 0.0f).method_1336(red, green, blue, alpha);
        });
    }

    public void renderTexture9Slice(class_332 context, class_2960 id, float x, float y, float width, float height, float[] slices) {
        context.method_64039(vcp -> {
            class_4588 vconsumer = vcp.getBuffer(class_1921.method_62277((class_2960)id));
            Matrix4f matrix = context.method_51448().method_23760().method_23761();
            class_1011 img = ((class_1043)mc.method_1531().method_4619(id)).method_4525();
            int texwidth = img.method_4307();
            int texheight = img.method_4323();
            float left = Math.min(slices[0], (float)texwidth / 2.0f);
            float right = Math.min(slices[1], (float)texwidth / 2.0f);
            float top = Math.min(slices[2], (float)texheight / 2.0f);
            float bottom = Math.min(slices[3], (float)texheight / 2.0f);
            float middlestart_hor = x + left;
            float middleend_hor = x + width - right;
            float middleend_tex_hor = ((float)texwidth - right) / (float)texwidth;
            float tls = left / (float)texwidth;
            float middlestart_ver = y + top;
            float middleend_ver = y + height - bottom;
            float middleend_tex_ver = ((float)texheight - bottom) / (float)texheight;
            float lts = top / (float)texheight;
            vconsumer.method_22918(matrix, x, y, 0.0f).method_22913(0.0f, 0.0f).method_39415(-1);
            vconsumer.method_22918(matrix, x, y + top, 0.0f).method_22913(0.0f, lts).method_39415(-1);
            vconsumer.method_22918(matrix, x + left, y + top, 0.0f).method_22913(tls, lts).method_39415(-1);
            vconsumer.method_22918(matrix, x + left, y, 0.0f).method_22913(tls, 0.0f).method_39415(-1);
            vconsumer.method_22918(matrix, middlestart_hor, y, 0.0f).method_22913(tls, 0.0f).method_39415(-1);
            vconsumer.method_22918(matrix, middlestart_hor, y + top, 0.0f).method_22913(tls, lts).method_39415(-1);
            vconsumer.method_22918(matrix, middleend_hor, y + top, 0.0f).method_22913(middleend_tex_hor, lts).method_39415(-1);
            vconsumer.method_22918(matrix, middleend_hor, y, 0.0f).method_22913(middleend_tex_hor, 0.0f).method_39415(-1);
            vconsumer.method_22918(matrix, middleend_hor, y, 0.0f).method_22913(middleend_tex_hor, 0.0f).method_39415(-1);
            vconsumer.method_22918(matrix, middleend_hor, y + top, 0.0f).method_22913(middleend_tex_hor, lts).method_39415(-1);
            vconsumer.method_22918(matrix, x + width, y + top, 0.0f).method_22913(1.0f, lts).method_39415(-1);
            vconsumer.method_22918(matrix, x + width, y, 0.0f).method_22913(1.0f, 0.0f).method_39415(-1);
            vconsumer.method_22918(matrix, x, middlestart_ver, 0.0f).method_22913(0.0f, lts).method_39415(-1);
            vconsumer.method_22918(matrix, x, middleend_ver, 0.0f).method_22913(0.0f, middleend_tex_ver).method_39415(-1);
            vconsumer.method_22918(matrix, x + left, middleend_ver, 0.0f).method_22913(tls, middleend_tex_ver).method_39415(-1);
            vconsumer.method_22918(matrix, x + left, middlestart_ver, 0.0f).method_22913(tls, lts).method_39415(-1);
            vconsumer.method_22918(matrix, middlestart_hor, middlestart_ver, 0.0f).method_22913(tls, lts).method_39415(-1);
            vconsumer.method_22918(matrix, middlestart_hor, middleend_ver, 0.0f).method_22913(tls, middleend_tex_ver).method_39415(-1);
            vconsumer.method_22918(matrix, middleend_hor, middleend_ver, 0.0f).method_22913(middleend_tex_hor, middleend_tex_ver).method_39415(-1);
            vconsumer.method_22918(matrix, middleend_hor, middlestart_ver, 0.0f).method_22913(middleend_tex_hor, lts).method_39415(-1);
            vconsumer.method_22918(matrix, middleend_hor, middlestart_ver, 0.0f).method_22913(middleend_tex_hor, lts).method_39415(-1);
            vconsumer.method_22918(matrix, middleend_hor, middleend_ver, 0.0f).method_22913(middleend_tex_hor, middleend_tex_ver).method_39415(-1);
            vconsumer.method_22918(matrix, x + width, middleend_ver, 0.0f).method_22913(1.0f, middleend_tex_ver).method_39415(-1);
            vconsumer.method_22918(matrix, x + width, middlestart_ver, 0.0f).method_22913(1.0f, lts).method_39415(-1);
            vconsumer.method_22918(matrix, x, middleend_ver, 0.0f).method_22913(0.0f, middleend_tex_ver).method_39415(-1);
            vconsumer.method_22918(matrix, x, y + height, 0.0f).method_22913(0.0f, 1.0f).method_39415(-1);
            vconsumer.method_22918(matrix, x + left, y + height, 0.0f).method_22913(tls, 1.0f).method_39415(-1);
            vconsumer.method_22918(matrix, x + left, middleend_ver, 0.0f).method_22913(tls, middleend_tex_ver).method_39415(-1);
            vconsumer.method_22918(matrix, middlestart_hor, middleend_ver, 0.0f).method_22913(tls, middleend_tex_ver).method_39415(-1);
            vconsumer.method_22918(matrix, middlestart_hor, y + height, 0.0f).method_22913(tls, 1.0f).method_39415(-1);
            vconsumer.method_22918(matrix, middleend_hor, y + height, 0.0f).method_22913(middleend_tex_hor, 1.0f).method_39415(-1);
            vconsumer.method_22918(matrix, middleend_hor, middleend_ver, 0.0f).method_22913(middleend_tex_hor, middleend_tex_ver).method_39415(-1);
            vconsumer.method_22918(matrix, middleend_hor, middleend_ver, 0.0f).method_22913(middleend_tex_hor, middleend_tex_ver).method_39415(-1);
            vconsumer.method_22918(matrix, middleend_hor, y + height, 0.0f).method_22913(middleend_tex_hor, 1.0f).method_39415(-1);
            vconsumer.method_22918(matrix, x + width, y + height, 0.0f).method_22913(1.0f, 1.0f).method_39415(-1);
            vconsumer.method_22918(matrix, x + width, middleend_ver, 0.0f).method_22913(1.0f, middleend_tex_ver).method_39415(-1);
        });
    }

    public void renderTexturedVertexArray(class_332 context, float[] vertices, float[] textures, class_2960 id, boolean triangles) {
        context.method_64039(vcp -> {
            class_4588 vertexConsumer = vcp.getBuffer(triangles ? this.TriangleTextureRenderType.apply(id) : class_1921.method_62277((class_2960)id));
            Matrix4f matrix = context.method_51448().method_23760().method_23761();
            for (int i = 0; i < vertices.length; i += 2) {
                vertexConsumer.method_22918(matrix, vertices[i], vertices[i + 1], 0.0f).method_22913(textures[i], textures[i + 1]).method_39415(-1);
            }
        });
    }

    public void renderColoredVertexArray(class_332 context, float[] vertices, int r, int g, int b, int a, boolean triangle_strip) {
        context.method_64039(v -> {
            class_4588 vconsumer = v.getBuffer(triangle_strip ? this.TriangleColorRenderType : class_1921.method_51784());
            Matrix4f matrix = context.method_51448().method_23760().method_23761();
            for (int i = 0; i < vertices.length; i += 2) {
                vconsumer.method_22918(matrix, vertices[i], vertices[i + 1], 0.0f).method_1336(r, g, b, a);
            }
        });
    }

    public void render(class_332 context, class_9779 delta) {
        block6: {
            try {
                if (!Hudder.config.limitrate) {
                    this.compman.compile(delta);
                }
                if (!Hudder.config.shouldDrawResult()) break block6;
                try {
                    if (this.compman.getResult() != null) {
                        this.drawCompileResult(context, HudderRenderer.mc.field_1772, this.compman.getResult(), Hudder.config, delta);
                        break block6;
                    }
                    this.renderFail(context, HudCompilationManager.LastFailMessage);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (RuntimeException e) {
                e.printStackTrace();
            }
        }
    }
}

