/*
 * Decompiled with CFR 0.152.
 */
package io.github.ngspace.hudder.v2runtime.functions;

import io.github.ngspace.hudder.Hudder;
import io.github.ngspace.hudder.compilers.utils.CompileException;
import io.github.ngspace.hudder.v2runtime.V2Runtime;
import io.github.ngspace.hudder.v2runtime.functions.ArrayV2Function;
import io.github.ngspace.hudder.v2runtime.functions.DoubleV2Function;
import io.github.ngspace.hudder.v2runtime.functions.IV2Function;
import io.github.ngspace.hudder.v2runtime.functions.LengthV2Function;
import io.github.ngspace.hudder.v2runtime.functions.RngV2Function;
import io.github.ngspace.hudder.v2runtime.functions.StringV2Function;
import io.github.ngspace.hudder.v2runtime.functions.TestFunction;
import io.github.ngspace.hudder.v2runtime.values.AV2Value;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import net.minecraft.class_1799;
import net.minecraft.class_310;

public class V2FunctionHandler {
    private static Map<String, IV2Function> functions = new HashMap<String, IV2Function>();
    protected static class_310 mc = class_310.method_1551();

    public V2FunctionHandler() {
        this.bindAllAPIFunctions();
    }

    public void bindAllAPIFunctions() {
        if (Hudder.IS_DEBUG) {
            this.bindFunction((IV2Function)new TestFunction(), 2, "test");
        }
        this.bindFunction((IV2Function)new DoubleV2Function(), 1, "int", "num", "number", "double");
        this.bindFunction((IV2Function)new StringV2Function(), 1, 2, "str", "string");
        this.bindFunction((IV2Function)new ArrayV2Function(), 1, 2, "array");
        this.bindFunction((V2Runtime r, String n, AV2Value[] args, int l, int c) -> Character.valueOf((char)args[0].asDouble()), 1, "char");
        this.bindFunction((V2Runtime r, String n, AV2Value[] args, int l, int c) -> Integer.toBinaryString((int)args[0].asDouble()), 1, "toBinaryString");
        this.bindFunctionDep((r, n, args, l, c) -> args[0].asString() + args[1].asString(), 2, 2, "Use \"[string].concat([string])\" function", "concat");
        this.bindFunctionDep((r, n, args, l, c) -> args[0].asString().substring(args[1].asInt(), args[2].asInt()), 3, 3, "Use \"[string].substring([number], [number])\" function", "substring");
        this.bindFunctionDep((r, n, args, l, c) -> args[0].asString().repeat(args[1].asInt()), 2, 2, "Use \"[string].repeat([number])\" function", "multiplystring", "repeat");
        this.bindFunction((IV2Function)new RngV2Function(), 2, 3, "rng", "random");
        this.bindFunction((V2Runtime r, String n, AV2Value[] args, int l, int c) -> Math.abs(args[0].asDouble()), 1, "abs");
        this.bindFunction((V2Runtime r, String n, AV2Value[] args, int l, int c) -> Math.floor(args[0].asDouble()), 1, "floor");
        this.bindFunction((V2Runtime r, String n, AV2Value[] args, int l, int c) -> Math.ceil(args[0].asDouble()), 1, "ceiling");
        this.bindFunction((V2Runtime r, String n, AV2Value[] args, int l, int c) -> Math.sin(args[0].asDouble()), 1, "sin");
        this.bindFunction((V2Runtime r, String n, AV2Value[] args, int l, int c) -> Math.cos(args[0].asDouble()), 1, "cos");
        this.bindFunction((V2Runtime r, String n, AV2Value[] args, int l, int c) -> Math.tan(args[0].asDouble()), 1, "tan");
        this.bindFunction((V2Runtime r, String n, AV2Value[] args, int l, int c) -> Math.asin(args[0].asDouble()), 1, "asin");
        this.bindFunction((V2Runtime r, String n, AV2Value[] args, int l, int c) -> Math.acos(args[0].asDouble()), 1, "acos");
        this.bindFunction((V2Runtime r, String n, AV2Value[] args, int l, int c) -> Math.atan(args[0].asDouble()), 1, "atan");
        this.bindFunction((V2Runtime r, String n, AV2Value[] args, int l, int c) -> Math.sqrt(args[0].asDouble()), 1, "sqrt");
        this.bindFunction((V2Runtime r, String n, AV2Value[] args, int l, int c) -> Math.pow(args[0].asDouble(), args[1].asDouble()), 2, "pow");
        this.bindFunction((V2Runtime r, String n, AV2Value[] args, int l, int c) -> Math.min(args[0].asDouble(), args[1].asDouble()), 2, "min");
        this.bindFunction((V2Runtime r, String n, AV2Value[] args, int l, int c) -> Math.max(args[0].asDouble(), args[1].asDouble()), 2, "max");
        this.bindFunction((V2Runtime r, String n, AV2Value[] args, int l, int c) -> Math.floor(args[0].asDouble() * Math.pow(10.0, args[1].asInt())) / Math.pow(10.0, args[1].asInt()), 2, "truncate");
        this.bindFunctionDep((r, n, args, l, c) -> V2FunctionHandler.mc.field_1724.method_31548().method_5438(args[0].asInt()).method_7954(), 1, 1, "Use \"getItem([number]).name\"", "itemname");
        this.bindFunctionDep((r, n, args, l, c) -> V2FunctionHandler.mc.field_1724.method_31548().method_5438(args[0].asInt()).method_7947(), 1, 1, "itemcount", new String[0]);
        this.bindFunctionDep((r, n, args, l, c) -> {
            class_1799 stack = V2FunctionHandler.mc.field_1724.method_31548().method_5438(args[0].asInt());
            return stack.method_7936() - stack.method_7919();
        }, 1, 1, "itemdurability", new String[0]);
        this.bindFunctionDep((r, n, args, l, c) -> V2FunctionHandler.mc.field_1724.method_31548().method_5438(args[0].asInt()).method_7936(), 1, 1, "itemmaxdurability", new String[0]);
        this.bindFunctionDep((r, n, args, l, c) -> V2FunctionHandler.mc.field_1724.method_31548().method_5438(args[0].asInt()).method_7914(), 1, 1, "itemmaxcount", new String[0]);
        this.bindFunction((IV2Function)new LengthV2Function(), 1, "length");
        this.bindFunction((V2Runtime r, String n, AV2Value[] args, int l, int c) -> () -> {
            try {
                if (args.length == 1) {
                    return new RangedIterator(this, 0, args[0].asInt());
                }
                return new RangedIterator(this, args[0].asInt(), args[1].asInt());
            }
            catch (CompileException e) {
                e.printStackTrace();
                throw new IllegalArgumentException(e);
            }
        }, 1, 2, "range");
    }

    private void bindFunctionDep(final IV2Function func, final int minlength, final int maxlength, final String message, String ... names) {
        IV2Function expandedFunction = new IV2Function(){

            @Override
            public Object execute(V2Runtime runtime, String name, AV2Value[] args, int line, int charpos) throws CompileException {
                if (args.length < minlength) {
                    throw new CompileException("Too little parameters for " + name + " function!", line, charpos);
                }
                if (args.length > maxlength) {
                    throw new CompileException("Too many parameters for " + name + " function!", line, charpos);
                }
                return func.execute(runtime, name, args, line, charpos);
            }

            @Override
            public String getDeprecationWarning(String funcname) {
                return message;
            }

            @Override
            public boolean isDeprecated(String funcname) {
                return true;
            }
        };
        this.bindFunction(expandedFunction, names);
    }

    public void bindFunction(IV2Function function, String ... names) {
        for (String name : names) {
            functions.put(name, function);
        }
    }

    public void bindFunction(IV2Function function, int length, String ... names) {
        this.bindFunction(function, length, length, names);
    }

    public void bindFunction(IV2Function function, int minlength, int maxlength, String ... names) {
        IV2Function expandedFunction = (runtime, name, args, line, charpos) -> {
            if (args.length < minlength) {
                throw new CompileException("Too little parameters for " + name + " function!", line, charpos);
            }
            if (args.length > maxlength) {
                throw new CompileException("Too many parameters for " + name + " function!", line, charpos);
            }
            return function.execute(runtime, name, args, line, charpos);
        };
        this.bindFunction(expandedFunction, names);
    }

    public IV2Function getFunction(String name) {
        return functions.get(name);
    }

    public class RangedIterator
    implements Iterator<Integer> {
        private int index;
        private int end;

        public RangedIterator(V2FunctionHandler this$0, int start, int end) {
            if (start > end) {
                throw new IllegalArgumentException("Start (" + start + ") can not be greater than end (" + end + ")!");
            }
            this.index = start;
            this.end = end;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.end;
        }

        @Override
        public Integer next() {
            if (this.index > this.end) {
                throw new NoSuchElementException("Went past end of iterable!");
            }
            return this.index++;
        }
    }
}

