/*
 * Decompiled with CFR 0.152.
 */
package io.github.ngspace.hudder.v2runtime.values;

import io.github.ngspace.hudder.compilers.abstractions.AV2Compiler;
import io.github.ngspace.hudder.compilers.utils.CompileException;
import io.github.ngspace.hudder.utils.HudderUtils;
import io.github.ngspace.hudder.v2runtime.V2Runtime;
import io.github.ngspace.hudder.v2runtime.values.AV2Value;
import io.github.ngspace.hudder.v2runtime.values.IV2VariableParser;
import io.github.ngspace.hudder.v2runtime.values.V2FunctionVar;
import io.github.ngspace.hudder.v2runtime.values.V2SystemVar;
import io.github.ngspace.hudder.v2runtime.values.constants.V2Array;
import io.github.ngspace.hudder.v2runtime.values.constants.V2Boolean;
import io.github.ngspace.hudder.v2runtime.values.constants.V2Number;
import io.github.ngspace.hudder.v2runtime.values.constants.V2String;
import io.github.ngspace.hudder.v2runtime.values.modifiable.V2ArrayRead;
import io.github.ngspace.hudder.v2runtime.values.modifiable.V2DynamicVar;
import io.github.ngspace.hudder.v2runtime.values.modifiable.V2SetValue;
import io.github.ngspace.hudder.v2runtime.values.modifiable.V2TempDynamicVar;
import io.github.ngspace.hudder.v2runtime.values.operations.V2ClassPropertyCall;
import io.github.ngspace.hudder.v2runtime.values.operations.V2MathOperation;
import io.github.ngspace.hudder.v2runtime.values.operations.V2PostIncDecOperator;
import io.github.ngspace.hudder.v2runtime.values.operations.V2PreIncDecOperator;
import io.github.ngspace.hudder.v2runtime.values.operations.booloperations.V2Comparison;
import io.github.ngspace.hudder.v2runtime.values.operations.booloperations.V2LogicalAND;
import io.github.ngspace.hudder.v2runtime.values.operations.booloperations.V2LogicalOR;
import io.github.ngspace.hudder.v2runtime.values.operations.booloperations.V2OppositeOperator;
import java.util.Arrays;
import java.util.Objects;

public class DefaultV2VariableParser
implements IV2VariableParser {
    @Override
    public AV2Value parse(V2Runtime runtime, String valuee, AV2Compiler comp, int line, int charpos) throws CompileException {
        AV2Value[] values;
        char c;
        int i;
        String value = valuee.trim();
        if (value.isBlank()) {
            throw new CompileException("Unknown variable: empty variable", line, charpos);
        }
        if (value.startsWith("(") && value.endsWith(")")) {
            boolean isSafe = true;
            int layers = 0;
            for (int i2 = 0; i2 < value.length(); ++i2) {
                char c2 = value.charAt(i2);
                if (c2 == '(') {
                    ++layers;
                }
                if (c2 == ')') {
                    --layers;
                }
                if (layers != 0) continue;
                isSafe = i2 + 1 == value.length();
                break;
            }
            if (isSafe) {
                return comp.getV2Value(runtime, value.substring(1, value.length() - 1), line, charpos);
            }
        }
        if (value.matches("((0x|#)[\\daAbBcCdDeEfF]+|[-+]*\\d*(\\.?(\\d+)?))")) {
            return new V2Number(value, line, charpos, comp);
        }
        if (value.equalsIgnoreCase("false")) {
            return new V2Boolean(false, comp, line, charpos, value);
        }
        if (value.equalsIgnoreCase("true")) {
            return new V2Boolean(true, comp, line, charpos, value);
        }
        V2String temp = this.string(value, comp, line, charpos);
        if (temp != null) {
            return temp;
        }
        if (value.matches("\\[[\\s\\S]*\\]")) {
            return new V2Array(HudderUtils.processParemeters(value.substring(1, value.length() - 1).replace("\n", "")), comp, runtime, line, charpos, value);
        }
        String[] setValues = value.split("=", 2);
        if (setValues.length == 2 && !this.isCondition(value)) {
            return new V2SetValue(comp.getV2Value(runtime, setValues[0], line, charpos), comp.getV2Value(runtime, setValues[1], line, charpos), comp, line, charpos, value);
        }
        boolean matchesVariableRegex = value.matches("[A-Za-z\\d][A-Za-z\\d_]*");
        if (matchesVariableRegex && comp.isSystemVariable(value.toLowerCase()) && comp.SYSTEM_VARIABLES_ENABLED) {
            return new V2SystemVar(value, comp, line, charpos);
        }
        if (matchesVariableRegex) {
            return new V2DynamicVar(value, runtime, line, charpos);
        }
        if (value.matches("_[A-Za-z\\d_]*")) {
            return new V2TempDynamicVar(value, comp, line, charpos);
        }
        if (value.matches(".+ *\\[.+\\]")) {
            return new V2ArrayRead(value, comp, runtime, line, charpos, value);
        }
        if (!value.startsWith("(") && value.endsWith(")")) {
            int argStart = value.indexOf("(");
            boolean isSafe = false;
            int parenthesses = 0;
            if (argStart != -1) {
                String funcName;
                isSafe = true;
                for (i = argStart; i < value.length(); ++i) {
                    c = value.charAt(i);
                    if (c == '(') {
                        ++parenthesses;
                    }
                    if (c == ')') {
                        --parenthesses;
                    }
                    if (parenthesses != 0) continue;
                    isSafe = i + 1 == value.length();
                    break;
                }
                if (isSafe && (funcName = value.substring(0, argStart)).matches("^[a-zA-Z0-9_-]*$")) {
                    String parametersString = value.substring(argStart + 1, value.length() - 1);
                    String[] tokenizedArgs = HudderUtils.processParemeters(parametersString);
                    return new V2FunctionVar(runtime, comp, funcName, tokenizedArgs, line, charpos, value);
                }
            }
        }
        if ((values = this.logicalOperator('|', value, runtime, line, charpos)).length > 1) {
            return new V2LogicalOR(values, line, charpos, value, comp);
        }
        values = this.logicalOperator('&', value, runtime, line, charpos);
        if (values.length > 1) {
            return new V2LogicalAND(values, line, charpos, value, comp);
        }
        String operator = this.getOperator(value);
        if (operator != null) {
            int parenthesses = 0;
            String[] v = value.split(operator, 2);
            for (char c3 : v[0].trim().toCharArray()) {
                if (c3 == '(') {
                    ++parenthesses;
                }
                if (c3 != ')') continue;
                --parenthesses;
            }
            if (parenthesses == 0) {
                return new V2Comparison(comp.getV2Value(runtime, v[0].trim(), line, charpos), comp.getV2Value(runtime, v[1].trim(), line, charpos), operator, line, charpos, value, comp);
            }
        }
        String classyobjname = "";
        Object functionOrObject = "";
        block3: for (i = 1; i < value.length(); ++i) {
            c = value.charAt(value.length() - i);
            if (c == ')') {
                int parentheses = 0;
                while (i < value.length() + 1) {
                    c = value.charAt(value.length() - i);
                    if (c == ')') {
                        ++parentheses;
                    }
                    if (c == '(') {
                        --parentheses;
                    }
                    functionOrObject = c + (String)functionOrObject;
                    if (parentheses == 0) continue block3;
                    ++i;
                }
                continue;
            }
            if (c == '\"') {
                boolean isnotescaped = false;
                while (i < value.length() + 1) {
                    c = value.charAt(value.length() - i);
                    functionOrObject = c + (String)functionOrObject;
                    if (i + 2 < value.length() + 1) {
                        boolean bl = isnotescaped = value.charAt(value.length() - i) == '\\';
                    }
                    if (c == '\"' && (i + 1 >= value.length() + 1 || value.charAt(value.length() - i) != '\\') && isnotescaped) continue block3;
                    ++i;
                }
                continue;
            }
            if (c == '.') {
                classyobjname = value.substring(0, value.length() - i);
                for (int j = 1; j < classyobjname.length(); ++j) {
                    char cc = classyobjname.charAt(classyobjname.length() - j);
                    if (Character.isDigit(cc)) continue;
                    if (cc != '*' && cc != '+' && cc != '-' && cc != '/' && cc != '%') break block3;
                    classyobjname = "";
                    functionOrObject = "";
                    break block3;
                }
                break;
            }
            functionOrObject = c + (String)functionOrObject;
        }
        if (!Objects.equals(functionOrObject, value) && !"".equals(classyobjname)) {
            return new V2ClassPropertyCall(charpos, charpos, value, comp, runtime, comp.getV2Value(runtime, classyobjname, line, charpos), (String)functionOrObject);
        }
        values = new AV2Value[]{};
        StringBuilder mathvalue = new StringBuilder();
        char[] operations = new char[]{};
        block7: for (int i3 = 0; i3 < value.length(); ++i3) {
            char c3;
            c3 = value.charAt(i3);
            if (c3 == '\"' && mathvalue.isEmpty()) {
                boolean safe = false;
                ++i3;
                mathvalue.append(c3);
                while (i3 < value.length()) {
                    c3 = value.charAt(i3);
                    if (c3 == '\\' && !safe) {
                        safe = true;
                        mathvalue.append(c3);
                    } else {
                        safe = false;
                        mathvalue.append(c3);
                        if (c3 == '\"' && !safe) continue block7;
                    }
                    ++i3;
                }
                continue;
            }
            if (c3 == '(' && mathvalue.isEmpty()) {
                int parentheses = 1;
                mathvalue.append(c3);
                ++i3;
                while (i3 < value.length()) {
                    c3 = value.charAt(i3);
                    if (c3 == '(') {
                        ++parentheses;
                    }
                    if (c3 == ')' && --parentheses == 0) {
                        mathvalue.append(c3);
                        continue block7;
                    }
                    mathvalue.append(c3);
                    ++i3;
                }
                continue;
            }
            if (c3 == '+' || c3 == '-' || c3 == '*' || c3 == '/' || c3 == '%') {
                if (mathvalue.toString().isBlank()) {
                    values = new AV2Value[]{};
                    break;
                }
                values = this.addToArray(values, comp.getV2Value(runtime, mathvalue.toString(), line, charpos));
                operations = this.addToArray(operations, c3);
                mathvalue.setLength(0);
                continue;
            }
            mathvalue.append(c3);
        }
        if (values.length > 0) {
            values = this.addToArray(values, comp.getV2Value(runtime, mathvalue.toString(), line, charpos));
            return new V2MathOperation(values, operations, line, charpos, value, comp);
        }
        if (value.matches("![\\s\\S]+")) {
            return new V2OppositeOperator(comp.getV2Value(runtime, value.substring(1), line, charpos), line, charpos, value, comp);
        }
        if (value.matches("[\\s\\S]+(\\+\\+|--)")) {
            return new V2PostIncDecOperator(comp.getV2Value(runtime, value.substring(0, value.length() - 2), line, charpos), comp, line, charpos, "+".equals(value.substring(value.length() - 1)), value);
        }
        if (value.matches("(\\+\\+|--)[\\s\\S]+")) {
            return new V2PreIncDecOperator(comp.getV2Value(runtime, value.substring(2), line, charpos), comp, line, charpos, "+".equals(value.substring(0, 1)), value);
        }
        throw new CompileException("Untokenizable variable: " + value, line, charpos);
    }

    private V2String string(String value, AV2Compiler compiler, int line, int charpos) {
        if (!value.startsWith("\"") || !value.endsWith("\"")) {
            return null;
        }
        value = value.substring(1, value.length() - 1);
        StringBuilder string = new StringBuilder();
        boolean safe = false;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == 'n' && safe) {
                string.append('\n');
                continue;
            }
            if (c == '\\' && !safe) {
                safe = true;
                continue;
            }
            if (c == '\"' && !safe) {
                return null;
            }
            safe = false;
            string.append(c);
        }
        return new V2String(string.toString(), compiler, line, charpos);
    }

    private AV2Value[] logicalOperator(char op, String value, V2Runtime runtime, int line, int charpos) throws CompileException {
        AV2Value[] values = new AV2Value[]{};
        StringBuilder builder = new StringBuilder();
        block0: for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '\"' && builder.isEmpty()) {
                boolean safe = false;
                ++i;
                builder.append(c);
                while (i < value.length()) {
                    c = value.charAt(i);
                    if (c == '\\' && !safe) {
                        safe = true;
                    } else {
                        safe = false;
                        builder.append(c);
                        if (c == '\"' && !safe) continue block0;
                    }
                    ++i;
                }
                continue;
            }
            if (c == '(' && builder.isEmpty()) {
                int parentheses = 1;
                ++i;
                while (i < value.length()) {
                    c = value.charAt(i);
                    if (c == '(') {
                        ++parentheses;
                    }
                    if (c == ')') {
                        --parentheses;
                    }
                    if (parentheses == 0) continue block0;
                    builder.append(c);
                    ++i;
                }
                continue;
            }
            if (c == op && i + 1 < value.length() && value.charAt(i + 1) == op) {
                ++i;
                values = this.addToArray(values, runtime.compiler.getV2Value(runtime, builder.toString(), line, charpos));
                builder.setLength(0);
                continue;
            }
            builder.append(c);
        }
        if (!Objects.equals(value, builder.toString())) {
            return this.addToArray(values, runtime.compiler.getV2Value(runtime, builder.toString(), line, charpos));
        }
        return values;
    }

    private <T> T[] addToArray(T[] arr, T t) {
        T[] newarr = Arrays.copyOf(arr, arr.length + 1);
        newarr[arr.length] = t;
        return newarr;
    }

    private char[] addToArray(char[] arr, char t) {
        char[] newarr = Arrays.copyOf(arr, arr.length + 1);
        newarr[arr.length] = t;
        return newarr;
    }

    private String getOperator(String condString) {
        if (condString.contains("==")) {
            return "==";
        }
        if (condString.contains("!=")) {
            return "!=";
        }
        if (condString.contains(">=")) {
            return ">=";
        }
        if (condString.contains("<=")) {
            return "<=";
        }
        if (condString.contains(">")) {
            return ">";
        }
        if (condString.contains("<")) {
            return "<";
        }
        return null;
    }

    private boolean isCondition(String key) {
        int i = key.indexOf(61);
        if (i == -1 && !key.contains(">") && !key.contains("<")) {
            return false;
        }
        if (i == key.length()) {
            return false;
        }
        if (i == 0) {
            return false;
        }
        char pre = key.charAt(i - 1);
        return pre == '<' || pre == '>' || pre == '!' || key.charAt(i + 1) == '=';
    }
}

