/*
 * Decompiled with CFR 0.152.
 */
package io.github.ngspace.hudder.v2runtime.values.constants;

import io.github.ngspace.hudder.compilers.abstractions.AV2Compiler;
import io.github.ngspace.hudder.compilers.utils.CompileException;
import io.github.ngspace.hudder.v2runtime.V2Runtime;
import io.github.ngspace.hudder.v2runtime.values.AV2Value;
import java.util.ArrayList;
import java.util.List;

public class V2Array
extends AV2Value {
    private AV2Value[] values;

    public V2Array(String[] strings, AV2Compiler compiler, V2Runtime runtime, int line, int charpos, String debugvalue) throws CompileException {
        super(line, charpos, debugvalue, compiler);
        this.values = new AV2Value[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            this.values[i] = compiler.getV2Value(runtime, strings[i], line, charpos);
        }
    }

    @Override
    public List<Object> get() throws CompileException {
        ArrayList<Object> array = new ArrayList<Object>();
        for (int i = 0; i < this.values.length; ++i) {
            array.add(this.values[i].get());
        }
        return array;
    }

    @Override
    public void setValue(AV2Compiler compiler, Object value) throws CompileException {
        throw new CompileException("Can't change the value of an array constant", this.line, this.charpos);
    }

    @Override
    public boolean isConstant() throws CompileException {
        return false;
    }
}

