/*
 * Decompiled with CFR 0.152.
 */
package io.github.ngspace.hudder.v2runtime.values.operations;

import io.github.ngspace.hudder.compilers.abstractions.AV2Compiler;
import io.github.ngspace.hudder.compilers.utils.CompileException;
import io.github.ngspace.hudder.v2runtime.values.AV2Value;

public class V2MathOperation
extends AV2Value {
    public AV2Value[] values = new AV2Value[0];
    public char[] operations = new char[0];
    public Object constant = null;

    public V2MathOperation(AV2Value[] values, char[] operations, int line, int charpos, String debugvalue, AV2Compiler compiler) throws CompileException {
        super(line, charpos, debugvalue, compiler);
        this.values = values;
        this.operations = operations;
        if (this.isConstant()) {
            this.constant = this.get();
        }
    }

    @Override
    public Object get() throws CompileException {
        double val2;
        int i;
        if (this.constant != null) {
            return this.constant;
        }
        Object[] processedValues = new Object[this.values.length];
        boolean should_concat = false;
        for (int i2 = 0; i2 < this.values.length; ++i2) {
            processedValues[i2] = this.values[i2].get();
            if (processedValues[i2] instanceof Number) continue;
            should_concat = true;
        }
        if (should_concat) {
            Object result = this.toString(processedValues[0]);
            for (int i3 = 0; i3 < this.operations.length; ++i3) {
                if (this.operations[i3] != '+') {
                    throw new CompileException("Unknown operator for str concatination: " + this.operations[i3], this.line, this.charpos);
                }
                result = (String)result + this.toString(processedValues[i3 + 1]);
            }
            return result;
        }
        double[] secondValues = new double[this.values.length];
        char[] secondsOperations = new char[this.operations.length];
        int realSecondValuesLength = 0;
        double result = this.getDouble(processedValues[0]);
        for (i = 0; i < this.values.length && i != this.operations.length; ++i) {
            val2 = this.getDouble(processedValues[i + 1]);
            if (this.operations[i] == '*') {
                result *= val2;
                continue;
            }
            if (this.operations[i] == '/') {
                result /= val2;
                continue;
            }
            if (this.operations[i] == '%') {
                result %= val2;
                continue;
            }
            secondValues[realSecondValuesLength] = result;
            secondsOperations[realSecondValuesLength] = this.operations[i];
            result = this.getDouble(processedValues[i + 1]);
            ++realSecondValuesLength;
        }
        secondValues[realSecondValuesLength] = result;
        ++realSecondValuesLength;
        result = secondValues[0];
        for (i = 0; i < realSecondValuesLength && i != realSecondValuesLength - 1; ++i) {
            val2 = secondValues[i + 1];
            if (secondsOperations[i] == '+') {
                result += val2;
                continue;
            }
            if (secondsOperations[i] != '-') continue;
            result -= val2;
        }
        return result;
    }

    private String toString(Object object) {
        Number num;
        if (object instanceof Number && (num = (Number)object).doubleValue() % 1.0 == 0.0) {
            return String.valueOf(num.intValue());
        }
        return String.valueOf(object);
    }

    private double getDouble(Object object) {
        return ((Number)object).doubleValue();
    }

    @Override
    public void setValue(AV2Compiler compiler, Object value) throws CompileException {
        throw new CompileException("Can't change the value of a math operation", this.line, this.charpos);
    }

    @Override
    public boolean isConstant() throws CompileException {
        return false;
    }
}

