/*
 * Decompiled with CFR 0.152.
 */
package io.github.ngspace.hudder.v2runtime.values.operations.booloperations;

import io.github.ngspace.hudder.compilers.abstractions.AV2Compiler;
import io.github.ngspace.hudder.compilers.utils.CompileException;
import io.github.ngspace.hudder.v2runtime.values.AV2Value;

public class V2LogicalAND
extends AV2Value {
    private AV2Value[] values;
    private Boolean constant;

    public V2LogicalAND(AV2Value[] values, int line, int charpos, String debugvalue, AV2Compiler compiler) throws CompileException {
        super(line, charpos, debugvalue, compiler);
        this.values = values;
        if (this.isConstant()) {
            this.constant = this.get();
        }
    }

    @Override
    public Boolean get() throws CompileException {
        if (this.constant != null) {
            return this.constant;
        }
        for (AV2Value value : this.values) {
            if (value.asBoolean()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setValue(AV2Compiler compiler, Object value) throws CompileException {
        throw new CompileException("Can't change the value of a logical or operation", this.line, this.charpos);
    }

    @Override
    public boolean isConstant() throws CompileException {
        for (AV2Value value : this.values) {
            if (value.isConstant()) continue;
            return false;
        }
        return true;
    }
}

